/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.OneTimeSchedule;
import org.evosuite.continuous.project.ProjectStaticData;

public class BudgetSchedule
extends OneTimeSchedule {
    public BudgetSchedule(JobScheduler scheduler) {
        super(scheduler);
    }

    @Override
    protected List<JobDefinition> createScheduleOnce() {
        ProjectStaticData data = this.scheduler.getProjectData();
        int maximumBudgetPerCore = 60 * this.scheduler.getConfiguration().timeInMinutes;
        int totalBudget = maximumBudgetPerCore * this.scheduler.getConfiguration().getNumberOfUsableCores();
        int minTime = 60 * this.scheduler.getConfiguration().minMinutesPerJob * data.getTotalNumberOfTestableCUTs();
        int extraTime = totalBudget - minTime;
        double timePerBranch = (double)extraTime / (double)data.getTotalNumberOfBranches();
        int totalLeftOver = 0;
        LinkedList<JobDefinition> jobs = new LinkedList<JobDefinition>();
        for (ProjectStaticData.ClassInfo info : data.getClassInfos()) {
            if (!info.isTestable()) continue;
            int budget = 60 * this.scheduler.getConfiguration().minMinutesPerJob + (int)(timePerBranch * (double)info.numberOfBranches);
            if (budget > maximumBudgetPerCore) {
                totalLeftOver += budget - maximumBudgetPerCore;
                budget = maximumBudgetPerCore;
            }
            JobDefinition job = new JobDefinition(budget, this.scheduler.getConfiguration().getConstantMemoryPerJob(), info.getClassName(), 0, null, null);
            jobs.add(job);
        }
        if (totalLeftOver > 0) {
            this.distributeExtraBudgetEvenly(jobs, totalLeftOver, maximumBudgetPerCore);
        }
        Collections.sort(jobs, new Comparator<JobDefinition>(){

            @Override
            public int compare(JobDefinition a, JobDefinition b) {
                return b.seconds - a.seconds;
            }
        });
        return jobs;
    }
}

