/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.OneTimeSchedule;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.utils.LoggingUtils;

public class HistorySchedule
extends OneTimeSchedule {
    private static double NEW_CLASS = 2.0;
    private static double OLD_CLASS = 1.0;
    public static final int COMMIT_IMPROVEMENT = 3;

    public HistorySchedule(JobScheduler scheduler) {
        super(scheduler);
    }

    @Override
    protected List<JobDefinition> createScheduleOnce() {
        ProjectStaticData data = this.scheduler.getProjectData();
        int maximumBudgetPerCore = 60 * this.scheduler.getConfiguration().timeInMinutes;
        int totalBudget = maximumBudgetPerCore * this.scheduler.getConfiguration().getNumberOfUsableCores();
        LoggingUtils.getEvoLogger().info("totalBudget: " + totalBudget);
        int minTime = 60 * this.scheduler.getConfiguration().minMinutesPerJob * data.getTotalNumberOfTestableCUTs();
        int extraTime = totalBudget - minTime;
        LoggingUtils.getEvoLogger().info("extraTime: " + extraTime);
        double timePerBranch = (double)extraTime / (double)data.getTotalNumberOfBranches();
        int totalLeftOver = 0;
        LinkedList<JobDefinition> jobs = new LinkedList<JobDefinition>();
        for (ProjectStaticData.ClassInfo c_info : data.getClassInfos()) {
            if (!c_info.isTestable()) continue;
            double budget = 60.0 * (double)this.scheduler.getConfiguration().minMinutesPerJob + (double)c_info.numberOfBranches * timePerBranch;
            if (c_info.hasChanged()) {
                budget *= NEW_CLASS;
                LoggingUtils.getEvoLogger().info("[M] " + c_info.getClassName());
            } else {
                if (!c_info.hasCoverageImproved()) {
                    LoggingUtils.getEvoLogger().info("[NI] " + c_info.getClassName());
                    continue;
                }
                budget *= OLD_CLASS;
                LoggingUtils.getEvoLogger().info("[O] " + c_info.getClassName());
            }
            if (budget > (double)maximumBudgetPerCore) {
                totalLeftOver = (int)((double)totalLeftOver + (budget - (double)maximumBudgetPerCore));
                budget = maximumBudgetPerCore;
            }
            jobs.add(new JobDefinition((int)budget, this.scheduler.getConfiguration().getConstantMemoryPerJob(), c_info.getClassName(), 0, null, null));
        }
        if (totalLeftOver > 0) {
            LoggingUtils.getEvoLogger().info("Distributing left budget (" + totalLeftOver + ")");
            this.distributeExtraBudgetEvenly(jobs, totalLeftOver, maximumBudgetPerCore);
        }
        Collections.sort(jobs, new Comparator<JobDefinition>(){

            @Override
            public int compare(JobDefinition a, JobDefinition b) {
                return b.seconds - a.seconds;
            }
        });
        int budgetUsed = 0;
        LinkedList<JobDefinition> jobsUnderBudget = new LinkedList<JobDefinition>();
        for (int i = 0; i < jobs.size(); ++i) {
            JobDefinition job = (JobDefinition)jobs.get(i);
            if (budgetUsed <= totalBudget) {
                LoggingUtils.getEvoLogger().info("+ Added class: " + job.cut + ", budget: " + job.seconds);
                jobsUnderBudget.add(job);
                budgetUsed += job.seconds;
                continue;
            }
            LoggingUtils.getEvoLogger().info("- Ignored class: " + job.cut + ", budget: " + job.seconds);
        }
        return jobsUnderBudget;
    }
}

