/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.persistency;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.evosuite.Properties;
import org.evosuite.continuous.persistency.CsvJUnitData;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.utils.Utils;
import org.evosuite.xsd.ProjectInfo;
import org.evosuite.xsd.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager {
    private static Logger logger = LoggerFactory.getLogger(StorageManager.class);
    public static final String TEST_FOLDER_NAME = "evosuite-tests";
    private final String rootFolderName;
    private final String projectFileName = "project_info.xml";
    private File tmpFolder;
    private File tmpLogs;
    private File tmpReports;
    private File tmpTests;
    private File tmpPools;
    private File tmpSeeds;
    private File testsFolder;

    public StorageManager(String rootFolderName) {
        this.rootFolderName = rootFolderName;
        this.tmpFolder = null;
    }

    public StorageManager() {
        this(Properties.CTG_FOLDER);
    }

    public boolean openForWriting() {
        boolean created = false;
        File root = new File(this.rootFolderName);
        if (root.exists()) {
            if (root.isDirectory()) {
                if (!root.canWrite()) {
                    logger.error("Cannot write in " + root.getAbsolutePath());
                    return false;
                }
            } else {
                boolean deleted = root.delete();
                if (!deleted) {
                    logger.error("Folder " + root + " is a file, and failed to delete it");
                    return false;
                }
                created = root.mkdirs();
                if (!created) {
                    logger.error("Failed to mkdir " + root.getAbsolutePath());
                    return false;
                }
            }
        } else {
            created = root.mkdirs();
            if (!created) {
                logger.error("Failed to mkdir " + root.getAbsolutePath());
                return false;
            }
        }
        this.testsFolder = new File(root.getAbsolutePath() + File.separator + TEST_FOLDER_NAME);
        if (!this.testsFolder.exists() && !(created = this.testsFolder.mkdirs())) {
            logger.error("Failed to mkdir " + this.testsFolder.getAbsolutePath());
            return false;
        }
        return true;
    }

    public void deleteOldTmpFolders() {
        File f = new File(this.getTmpFolderPath());
        FileUtils.deleteQuietly(f);
    }

    private String getTmpFolderPath() {
        return this.rootFolderName + "/" + Properties.CTG_TMP_FOLDER;
    }

    public boolean createNewTmpFolders() {
        String tmpPath = this.getTmpFolderPath();
        Date now = new Date();
        String time = DateFormatUtils.format(now, "yyyy_MM_dd_HH_mm_ss", Locale.getDefault());
        File tmp = new File(tmpPath + "/tmp_" + time + "_" + UUID.randomUUID().toString());
        boolean created = new File(tmpPath).exists() ? tmp.mkdir() : tmp.mkdirs();
        if (!created) {
            this.tmpFolder = null;
            return false;
        }
        this.tmpFolder = tmp;
        this.tmpLogs = new File(this.tmpFolder.getAbsolutePath() + "/logs");
        this.tmpLogs.mkdirs();
        this.tmpReports = new File(this.tmpFolder.getAbsolutePath() + "/reports");
        this.tmpReports.mkdirs();
        this.tmpTests = new File(this.tmpFolder.getAbsolutePath() + "/tests");
        this.tmpTests.mkdirs();
        this.tmpPools = new File(this.tmpFolder.getAbsolutePath() + "/pools");
        this.tmpPools.mkdirs();
        this.tmpSeeds = new File(tmpPath + "/" + Properties.SEED_DIR);
        this.tmpSeeds.mkdirs();
        return true;
    }

    public boolean clean() {
        try {
            FileUtils.deleteDirectory(new File(this.rootFolderName));
        }
        catch (IOException e) {
            logger.error("Cannot delete folder " + this.rootFolderName + ": " + e, e);
            return false;
        }
        return true;
    }

    public String mergeAndCommitChanges(ProjectStaticData current) throws NullPointerException {
        if (current == null) {
            throw new NullPointerException("ProjectStaticData 'current' cannot be null");
        }
        ProjectInfo db = this.getDatabaseProjectInfo();
        String info = this.removeNoMoreExistentData(db, current);
        info = info + "\n\n=== CTG run results ===";
        List<TestsOnDisk> suites = this.gatherGeneratedTestsOnDisk();
        info = info + "\nNew test suites: " + suites.size();
        int better = 0;
        for (TestsOnDisk suite : suites) {
            if (!this.isBetterThanOldOne(suite, db)) continue;
            this.updateDatabase(suite, db);
            ++better;
        }
        info = info + "\nBetter test suites: " + better;
        this.updateProjectStatistics(db, current);
        this.commitDatabase(db);
        return info;
    }

    public List<TestsOnDisk> gatherGeneratedTestsOnDisk() {
        LinkedList<TestsOnDisk> list = new LinkedList<TestsOnDisk>();
        List<File> generatedTests = Utils.getAllFilesInSubFolder(this.tmpTests.getAbsolutePath(), ".java");
        List<File> generatedReports = Utils.getAllFilesInSubFolder(this.tmpReports.getAbsolutePath(), ".csv");
        LinkedHashMap<String, CsvJUnitData> reports = new LinkedHashMap<String, CsvJUnitData>();
        for (File file : generatedReports) {
            CsvJUnitData data = CsvJUnitData.openFile(file);
            if (data == null) {
                logger.warn("Cannot process " + file.getAbsolutePath());
                continue;
            }
            reports.put(data.getTargetClass(), data);
        }
        for (File test : generatedTests) {
            String testName = this.extractClassName(this.tmpTests, test);
            String cut = "";
            for (String className : reports.keySet()) {
                if (!testName.startsWith(className) || className.length() <= cut.length()) continue;
                cut = className;
            }
            CsvJUnitData data = (CsvJUnitData)reports.get(cut);
            if (data == null) {
                logger.warn("No CSV file for CUT " + cut + " with test suite at " + test.getAbsolutePath());
                continue;
            }
            TestsOnDisk info = new TestsOnDisk(test, data);
            if (info.isValid()) {
                list.add(info);
                continue;
            }
            logger.warn("Invalid info for " + test.getAbsolutePath());
        }
        return list;
    }

    protected String extractClassName(File base, File target) {
        int len = base.getAbsolutePath().length();
        String path = target.getAbsolutePath();
        String name = path.substring(len + 1, path.length() - ".java".length());
        if ((name = name.replaceAll("/", ".")).contains("\\")) {
            name = name.replaceAll("\\\\", ".");
        }
        return name;
    }

    private void commitDatabase(ProjectInfo db) {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance(ProjectInfo.class);
            Marshaller m = context.createMarshaller();
            m.marshal((Object)db, writer);
        }
        catch (Exception e) {
            logger.error("Failed to create XML representation: " + e.getMessage(), e);
        }
        String xml = writer.toString();
        File current = new File(this.rootFolderName + File.separator + "project_info.xml");
        current.delete();
        try {
            FileUtils.write(current, xml);
        }
        catch (IOException e) {
            logger.error("Failed to write to database: " + e.getMessage(), e);
        }
    }

    private void updateProjectStatistics(ProjectInfo db, ProjectStaticData current) {
        db.setTotalNumberOfClasses(BigInteger.valueOf(current.getTotalNumberOfClasses()));
        int n = current.getTotalNumberOfTestableCUTs();
        db.setTotalNumberOfTestableClasses(BigInteger.valueOf(n));
        double coverage = 0.0;
        for (TestSuite suite : db.getGeneratedTestSuites()) {
            coverage += suite.getBranchCoverage();
        }
        db.setAverageBranchCoverage(coverage /= (double)n);
    }

    private void updateDatabase(TestsOnDisk ondisk, ProjectInfo db) {
        assert (ondisk.isValid());
        TestSuite suite = new TestSuite();
        CsvJUnitData csv = ondisk.csvData;
        suite.setBranchCoverage(csv.getBranchCoverage());
        suite.setFullNameOfTargetClass(csv.getTargetClass());
        suite.setNumberOfTests(BigInteger.valueOf(csv.getNumberOfTests()));
        suite.setTotalNumberOfStatements(BigInteger.valueOf(csv.getTotalNumberOfStatements()));
        TestSuite old = null;
        Iterator<TestSuite> iter = db.getGeneratedTestSuites().iterator();
        while (iter.hasNext()) {
            TestSuite tmp = iter.next();
            if (!tmp.getFullNameOfTargetClass().equals(csv.getTargetClass())) continue;
            old = tmp;
            iter.remove();
            break;
        }
        int oldTotalEffort = 0;
        int oldEffortFromModification = 0;
        if (old != null) {
            oldTotalEffort = old.getTotalEffortInSeconds().intValue();
            oldEffortFromModification = old.getEffortFromLastModificationInSeconds().intValue();
        }
        int duration = oldTotalEffort + csv.getDurationInSeconds();
        suite.setEffortFromLastModificationInSeconds(BigInteger.valueOf(oldEffortFromModification + duration));
        suite.setTotalEffortInSeconds(BigInteger.valueOf(oldTotalEffort + duration));
        String testName = this.extractClassName(this.tmpTests, ondisk.testSuite);
        suite.setFullNameOfTestSuite(testName);
        db.getGeneratedTestSuites().add(suite);
        this.removeTestSuite(testName);
        this.addTestSuite(ondisk.testSuite);
        File scaffolding = this.getScaffoldingIfExists(ondisk.testSuite);
        if (scaffolding != null) {
            this.addTestSuite(scaffolding);
        }
    }

    private File getScaffoldingIfExists(File testSuite) throws IllegalArgumentException {
        String java = ".java";
        if (testSuite == null || !testSuite.exists() || !testSuite.getName().endsWith(java)) {
            throw new IllegalArgumentException("Invalid test suite: " + testSuite);
        }
        String name = testSuite.getName();
        String scaffoldingName = name.substring(0, name.length() - java.length());
        scaffoldingName = scaffoldingName + "_" + Properties.SCAFFOLDING_SUFFIX;
        scaffoldingName = scaffoldingName + java;
        File scaffolding = new File(testSuite.getParentFile().getAbsolutePath() + File.separator + scaffoldingName);
        if (scaffolding.exists()) {
            return scaffolding;
        }
        return null;
    }

    private void addTestSuite(File newlyGeneratedTestSuite) {
        String testName = this.extractClassName(this.tmpTests, newlyGeneratedTestSuite);
        String path = testName.replace(".", File.separator);
        path = path + ".java";
        File file = new File(this.testsFolder.getAbsolutePath() + File.separator + path);
        try {
            FileUtils.copyFile(newlyGeneratedTestSuite, file);
        }
        catch (IOException e) {
            logger.error("Failed to copy new generated test suite into the current best set: " + e.getMessage(), e);
        }
    }

    private boolean isBetterThanOldOne(TestsOnDisk suite, ProjectInfo db) {
        if (suite.csvData == null) {
            return false;
        }
        TestSuite old = null;
        for (TestSuite tmp : db.getGeneratedTestSuites()) {
            if (!tmp.getFullNameOfTargetClass().equals(suite.cut)) continue;
            old = tmp;
            break;
        }
        if (old == null) {
            return true;
        }
        double oldCov = old.getBranchCoverage();
        double newCov = suite.csvData.getBranchCoverage();
        double covDif = Math.abs(newCov - oldCov);
        if (covDif > 1.0E-4) {
            return newCov > oldCov;
        }
        int oldFail = old.getFailures().size();
        int newFail = suite.csvData.getTotalNumberOfFailures();
        if (newFail != oldFail) {
            return newFail > oldFail;
        }
        int oldSize = old.getTotalNumberOfStatements().intValue();
        int newSize = suite.csvData.getTotalNumberOfStatements();
        return newSize < oldSize;
    }

    private String removeNoMoreExistentData(ProjectInfo db, ProjectStaticData current) {
        int removed = 0;
        Iterator<TestSuite> iter = db.getGeneratedTestSuites().iterator();
        while (iter.hasNext()) {
            TestSuite suite = iter.next();
            String cut = suite.getFullNameOfTargetClass();
            if (current.containsClass(cut)) continue;
            iter.remove();
            this.removeTestSuite(suite.getFullNameOfTestSuite());
            ++removed;
        }
        return "Removed test suites: " + removed;
    }

    private void removeTestSuite(String testName) {
        String path = testName.replace(".", File.separator);
        path = path + ".java";
        File file = new File(this.testsFolder.getAbsolutePath() + File.separator + path);
        if (!file.exists()) {
            logger.debug("Nothing to delete, as following file does not exist: " + file.getAbsolutePath());
        } else {
            boolean deleted = file.delete();
            if (!deleted) {
                logger.warn("Failed to delete " + file.getAbsolutePath());
            }
        }
    }

    public ProjectInfo getDatabaseProjectInfo() {
        File current = new File(this.rootFolderName + File.separator + "project_info.xml");
        InputStream stream = null;
        if (!current.exists()) {
            String empty = "/xsd/ctg_project_report_empty.xml";
            try {
                stream = this.getClass().getResourceAsStream(empty);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read resource " + empty + " , " + e.getMessage());
            }
        }
        try {
            stream = new FileInputStream(current);
        }
        catch (FileNotFoundException e) {
            assert (false);
            throw new RuntimeException("Bug in EvoSuite framework: " + e.getMessage());
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(ProjectInfo.class);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(this.getClass().getResourceAsStream("/xsd/ctg_project_report.xsd")));
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setSchema(schema);
            ProjectInfo project = (ProjectInfo)jaxbUnmarshaller.unmarshal(stream);
            return project;
        }
        catch (Exception e) {
            String msg = "Error in reading " + current.getAbsolutePath() + " , " + e;
            logger.error(msg, e);
            throw new RuntimeException(msg);
        }
    }

    public File getTmpFolder() {
        return this.tmpFolder;
    }

    public File getTmpLogs() {
        return this.tmpLogs;
    }

    public File getTmpReports() {
        return this.tmpReports;
    }

    public File getTmpTests() {
        return this.tmpTests;
    }

    public File getTmpPools() {
        return this.tmpPools;
    }

    public File getTmpSeeds() {
        return this.tmpSeeds;
    }

    public static class TestsOnDisk {
        public final File testSuite;
        public final String cut;
        public final CsvJUnitData csvData;

        public TestsOnDisk(File testSuite, CsvJUnitData csvData) {
            this.testSuite = testSuite;
            this.csvData = csvData;
            this.cut = csvData.getTargetClass();
        }

        public TestsOnDisk(File testSuite, File csvFile, String cut) {
            this.testSuite = testSuite;
            this.cut = cut;
            this.csvData = CsvJUnitData.openFile(csvFile);
        }

        public boolean isValid() {
            return this.testSuite != null && this.testSuite.exists() && this.cut != null && !this.cut.isEmpty() && this.csvData != null && this.cut.equals(this.csvData.getTargetClass());
        }
    }
}

