/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Method;
import java.util.List;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualsContract
extends Contract {
    private static Logger logger = LoggerFactory.getLogger(Contract.class);

    @Override
    public ContractViolation check(StatementInterface statement, Scope scope, Throwable exception) {
        for (VariableReference var : this.getAllVariables(scope)) {
            Object object;
            block8: {
                object = scope.getObject(var);
                if (object == null) continue;
                Class[] parameters = new Class[]{Object.class};
                try {
                    Method equalsMethod = object.getClass().getMethod("equals", parameters);
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) {
                    }
                    break block8;
                }
                catch (SecurityException e1) {
                }
                catch (NoSuchMethodException e1) {}
                continue;
            }
            try {
                if (object.equals(object)) continue;
                return new ContractViolation(this, statement, exception, var);
            }
            catch (NullPointerException e) {
            }
            catch (Throwable t) {
            }
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(StatementInterface statement, List<VariableReference> variables, Throwable exception) {
        EqualsAssertion assertion = new EqualsAssertion();
        assertion.setStatement(statement);
        assertion.setSource(variables.get(0));
        assertion.setDest(variables.get(0));
        assertion.setValue(true);
        statement.addAssertion(assertion);
        statement.addComment("Violates contract a.equals(a)");
    }

    public String toString() {
        return "Equality check";
    }
}

