/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.PrimitiveExpression;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.VariableReference;
import org.evosuite.testcase.VariableReferenceImpl;
import org.evosuite.utils.GenericMethod;

public class EqualsHashcodeContract
extends Contract {
    @Override
    public ContractViolation check(StatementInterface statement, Scope scope, Throwable exception) {
        for (Contract.Pair<VariableReference> pair : this.getAllVariablePairs(scope)) {
            Object object2;
            Object object1;
            block5: {
                if (pair.object1 == pair.object2) continue;
                object1 = scope.getObject((VariableReference)pair.object1);
                object2 = scope.getObject((VariableReference)pair.object2);
                if (object1 == null || object2 == null) continue;
                Class[] parameters = new Class[]{Object.class};
                try {
                    Method equalsMethod = object1.getClass().getMethod("equals", parameters);
                    Method hashCodeMethod = object1.getClass().getMethod("hashCode", new Class[0]);
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) continue;
                    if (hashCodeMethod.getDeclaringClass().equals(Object.class)) {
                    }
                    break block5;
                }
                catch (SecurityException e1) {
                }
                catch (NoSuchMethodException e1) {}
                continue;
            }
            if (!(object1.equals(object2) ? object1.hashCode() != object2.hashCode() : object1.hashCode() == object2.hashCode())) continue;
            return new ContractViolation(this, statement, exception, (VariableReference)pair.object1, (VariableReference)pair.object2);
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(StatementInterface statement, List<VariableReference> variables, Throwable exception) {
        TestCase test = statement.getTestCase();
        VariableReference a = variables.get(0);
        VariableReference b = variables.get(1);
        try {
            Method equalsMethod = a.getGenericClass().getRawClass().getMethod("equals", Object.class);
            Method hashCodeMethod = a.getGenericClass().getRawClass().getMethod("hashCode", new Class[0]);
            GenericMethod genericEqualsMethod = new GenericMethod(equalsMethod, a.getGenericClass());
            GenericMethod genericHashCodeMethod = new GenericMethod(hashCodeMethod, a.getGenericClass());
            MethodStatement st1 = new MethodStatement(test, genericEqualsMethod, a, Arrays.asList(b));
            VariableReference x = test.addStatement(st1, statement.getPosition() + 1);
            MethodStatement st2 = new MethodStatement(test, genericHashCodeMethod, a, Arrays.asList(new VariableReference[0]));
            VariableReference y = test.addStatement(st2, statement.getPosition() + 2);
            MethodStatement st3 = new MethodStatement(test, genericHashCodeMethod, b, Arrays.asList(new VariableReference[0]));
            VariableReference z = test.addStatement(st3, statement.getPosition() + 3);
            VariableReference w = new VariableReferenceImpl(test, Boolean.TYPE);
            PrimitiveExpression exp = new PrimitiveExpression(test, w, y, PrimitiveExpression.Operator.EQUALS, z);
            w = test.addStatement(exp, statement.getPosition() + 4);
            StatementInterface newStatement = test.getStatement(w.getStPosition());
            EqualsAssertion assertion = new EqualsAssertion();
            assertion.setStatement(newStatement);
            assertion.setSource(x);
            assertion.setDest(w);
            assertion.setValue(true);
            newStatement.addAssertion(assertion);
            newStatement.addComment("Violates contract equals - hashcode");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Equals hashcode check";
    }
}

