/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.ConstantValue;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;

public class EqualsNullContract
extends Contract {
    @Override
    public ContractViolation check(StatementInterface statement, Scope scope, Throwable exception) {
        for (VariableReference var : this.getAllVariables(scope)) {
            Object object;
            block8: {
                logger.debug("Current variable: " + var);
                object = scope.getObject(var);
                logger.debug("Current object: " + object);
                if (object == null) continue;
                Class[] parameters = new Class[]{Object.class};
                try {
                    Method equalsMethod = object.getClass().getMethod("equals", parameters);
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) {
                    }
                    break block8;
                }
                catch (SecurityException e1) {
                }
                catch (NoSuchMethodException e1) {}
                continue;
            }
            logger.debug("Defines equals");
            try {
                if (object.equals(null)) {
                    logger.debug("Violation found");
                    return new ContractViolation(this, statement, exception, var);
                }
                logger.debug("No violation found");
            }
            catch (Throwable t) {
                logger.debug("Exception: " + t);
            }
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(StatementInterface statement, List<VariableReference> variables, Throwable exception) {
        EqualsAssertion assertion = new EqualsAssertion();
        assertion.setStatement(statement);
        VariableReference var = variables.get(0);
        assertion.setSource(var);
        assertion.setDest(new ConstantValue(statement.getTestCase(), (Type)((Object)Object.class)));
        assertion.setValue(false);
        statement.addAssertion(assertion);
        statement.addComment("Violates contract equals(null)");
    }

    public String toString() {
        return "Equals null check";
    }
}

