/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import org.evosuite.contracts.Contract;
import org.evosuite.testcase.ExecutionObserver;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleContractChecker
extends ExecutionObserver {
    private final Contract contract;
    private static final Logger logger = LoggerFactory.getLogger(SingleContractChecker.class);
    private boolean valid = true;

    public SingleContractChecker(Contract contract) {
        this.contract = contract;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void afterStatement(StatementInterface statement, Scope scope, Throwable exception) {
        try {
            logger.debug("Checking contract " + this.contract);
            if (this.contract.check(statement, scope, exception) != null) {
                this.valid = false;
            }
        }
        catch (Throwable t) {
            logger.info("Caught exception during contract checking: " + t);
        }
    }

    @Override
    public void beforeStatement(StatementInterface statement, Scope scope) {
    }

    @Override
    public void clear() {
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

