/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.util.Arrays;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStatisticsPrinter {
    private static final Logger logger = LoggerFactory.getLogger(ClassStatisticsPrinter.class);

    private static void reinstrument(Properties.Criterion criterion) {
        Properties.CRITERION = new Properties.Criterion[1];
        Properties.CRITERION[0] = criterion;
        logger.info("Re-instrumenting for criterion: " + (Object)((Object)criterion));
        TestGenerationContext.getInstance().resetContext();
        Properties.getTargetClass(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printClassStatistics() {
        Properties.Criterion[] oldCriterion;
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Sandbox.goingToExecuteUnsafeCodeOnSameThread();
        try {
            Class<?> targetClass = Properties.getTargetClass(false);
            if (targetClass != null) {
                LoggingUtils.getEvoLogger().info("* Finished analyzing classpath");
            } else {
                LoggingUtils.getEvoLogger().info("* Error while initializing target class, not continuing");
            }
        }
        catch (Throwable e) {
            LoggingUtils.getEvoLogger().error("* Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
            return;
        }
        finally {
            Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
        }
        for (Properties.Criterion criterion : oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length)) {
            ClassStatisticsPrinter.reinstrument(criterion);
            List<TestFitnessFactory<? extends TestFitnessFunction>> factories = TestSuiteGenerator.getFitnessFactory();
            int numGoals = 0;
            for (TestFitnessFactory<? extends TestFitnessFunction> factory : factories) {
                if (Properties.PRINT_GOALS) {
                    for (TestFitnessFunction testFitnessFunction : factory.getCoverageGoals()) {
                        LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                    }
                }
                numGoals += factory.getCoverageGoals().size();
            }
            LoggingUtils.getEvoLogger().info("* Criterion " + (Object)((Object)criterion) + ": " + numGoals);
        }
    }
}

