/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import java.util.List;
import org.evosuite.testcase.EvosuiteError;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestCoverageGoal {
    protected static final Logger logger = LoggerFactory.getLogger(TestCoverageGoal.class);

    public abstract boolean isCovered(TestChromosome var1);

    public boolean isCovered(List<TestChromosome> tests) {
        for (TestChromosome test : tests) {
            if (!this.isCovered(test)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTimeout(ExecutionResult result) {
        if (result == null) {
            logger.warn("Result is null!");
            return false;
        }
        if (result.test == null) {
            logger.warn("Test is null!");
            return false;
        }
        int size = result.test.size();
        return result.isThereAnExceptionAtPosition(size) && result.getExceptionThrownAtPosition(size) instanceof TestCaseExecutor.TimeoutExceeded;
    }

    protected ExecutionResult runTest(TestChromosome test) {
        if (!test.isChanged() && test.getLastExecutionResult() != null) {
            return test.getLastExecutionResult();
        }
        try {
            ExecutionResult result = TestCaseExecutor.getInstance().execute(test.getTestCase());
            return result;
        }
        catch (Exception e) {
            logger.error("TG: Exception caught: ", e);
            throw new EvosuiteError(e);
        }
    }
}

