/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ambiguity;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class AmbiguityCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 1893060100346404496L;

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        List<ExecutionResult> results = this.runTestSuite(suite);
        List<AmbiguityCoverageTestFitness> goals = AmbiguityCoverageFactory.retrieveCoverageGoals();
        ArrayList<StringBuilder> transposed_matrix = new ArrayList<StringBuilder>(AmbiguityCoverageFactory.getTransposedMatrix());
        int g_i = 0;
        for (TestFitnessFunction testFitnessFunction : goals) {
            StringBuilder str = new StringBuilder();
            for (ExecutionResult result : results) {
                if (testFitnessFunction.isCovered(result)) {
                    str.append("1");
                    continue;
                }
                str.append("0");
            }
            try {
                transposed_matrix.set(g_i, str.append((CharSequence)transposed_matrix.get(g_i)));
            }
            catch (IndexOutOfBoundsException exp) {
                transposed_matrix.add(g_i, str);
            }
            ++g_i;
        }
        double fitness = AmbiguityCoverageFactory.getAmbiguity(transposed_matrix);
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }

    @Override
    public boolean isMaximizationFunction() {
        return false;
    }
}

