/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.ControlFlowDistance;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.branch.ControlFlowDistanceCalculator;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.ExecutionResult;

public class BranchCoverageGoal
implements Serializable,
Comparable<BranchCoverageGoal> {
    private static final long serialVersionUID = 2962922303111452419L;
    private transient Branch branch;
    private final boolean value;
    private final String className;
    private final String methodName;
    private final int lineNumber;

    public BranchCoverageGoal(Branch branch, boolean value, String className, String methodName) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        if (branch == null && !value) {
            throw new IllegalArgumentException("expect goals for a root branch to always have value set to true");
        }
        this.branch = branch;
        this.value = value;
        this.className = className;
        this.methodName = methodName;
        if (branch != null) {
            this.lineNumber = branch.getInstruction().getLineNumber();
            if (!branch.getMethodName().equals(methodName) || !branch.getClassName().equals(className)) {
                throw new IllegalArgumentException("expect explicitly given information about a branch to coincide with the information given by that branch");
            }
        } else {
            this.lineNumber = BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getFirstLineNumberOfMethod(className, methodName);
        }
    }

    public BranchCoverageGoal(ControlDependency cd, String className, String methodName) {
        this(cd.getBranch(), cd.getBranchExpressionValue(), className, methodName);
    }

    public BranchCoverageGoal(String className, String methodName) {
        this.branch = null;
        this.value = true;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getFirstLineNumberOfMethod(className, methodName);
    }

    public Branch getBranch() {
        return this.branch;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isConnectedTo(BranchCoverageGoal goal) {
        if (this.branch == null || goal.branch == null) {
            return goal.methodName.equals(this.methodName) && goal.className.equals(this.className);
        }
        return this.branch.getInstruction().isDirectlyControlDependentOn(goal.branch) || goal.branch.getInstruction().isDirectlyControlDependentOn(this.branch);
    }

    public ControlFlowDistance getDistance(ExecutionResult result) {
        ControlFlowDistance r = ControlFlowDistanceCalculator.getDistance(result, this.branch, this.value, this.className, this.methodName);
        return r;
    }

    public String toString() {
        String name = this.className + "." + this.methodName + ":";
        if (this.branch != null) {
            name = name + " " + this.branch.toString();
            name = this.value ? name + " - true" : name + " - false";
        } else {
            name = name + " root-Branch";
        }
        return name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branch == null ? 0 : this.branch.getActualBranchId());
        result = 31 * result + (this.branch == null ? 0 : this.branch.getInstruction().getInstructionId());
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchCoverageGoal other = (BranchCoverageGoal)obj;
        if (this.branch == null) {
            if (other.branch != null) {
                return false;
            }
            return this.methodName.equals(other.methodName) && this.className.equals(other.className);
        }
        if (other.branch == null) {
            return false;
        }
        if (!this.branch.equals(other.branch)) {
            return false;
        }
        return this.value == other.value;
    }

    @Override
    public int compareTo(BranchCoverageGoal o) {
        int diff = this.lineNumber - o.lineNumber;
        if (diff == 0) {
            if (this.branch == null || o.getBranch() == null) {
                return 0;
            }
            return this.branch.getActualBranchId() - o.getBranch().getActualBranchId();
        }
        return diff;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.branch != null) {
            oos.writeInt(this.branch.getActualBranchId());
        } else {
            oos.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        int branchId = ois.readInt();
        this.branch = branchId >= 0 ? BranchPool.getBranch(branchId) : null;
    }
}

