/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.setup.DependencyAnalysis;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchPool {
    private static Logger logger = LoggerFactory.getLogger(BranchPool.class);
    private static Map<String, Map<String, List<Branch>>> branchMap = new HashMap<String, Map<String, List<Branch>>>();
    private static Map<String, Map<String, Integer>> branchlessMethods = new HashMap<String, Map<String, Integer>>();
    private static Map<Integer, Branch> branchIdMap = new HashMap<Integer, Branch>();
    private static Map<BytecodeInstruction, Integer> registeredNormalBranches = new HashMap<BytecodeInstruction, Integer>();
    private static Map<BytecodeInstruction, List<Branch>> registeredSwitches = new HashMap<BytecodeInstruction, List<Branch>>();
    private static Map<BytecodeInstruction, Branch> registeredDefaultCases = new HashMap<BytecodeInstruction, Branch>();
    private static Map<LabelNode, List<Branch>> switchLabels = new HashMap<LabelNode, List<Branch>>();
    private static int branchCounter = 0;

    public static void addBranchlessMethod(String className, String methodName, int lineNumber) {
        if (!branchlessMethods.containsKey(className)) {
            branchlessMethods.put(className, new HashMap());
        }
        branchlessMethods.get(className).put(methodName, lineNumber);
    }

    public static void registerAsBranch(BytecodeInstruction instruction) {
        if (!instruction.isActualBranch()) {
            throw new IllegalArgumentException("CFGVertex of a branch expected");
        }
        if (BranchPool.isKnownAsBranch(instruction)) {
            return;
        }
        if (!DependencyAnalysis.shouldInstrument(instruction.getClassName(), instruction.getMethodName())) {
            return;
        }
        BranchPool.registerInstruction(instruction);
    }

    private static void registerInstruction(BytecodeInstruction v) {
        if (BranchPool.isKnownAsBranch(v)) {
            throw new IllegalStateException("expect registerInstruction() to be called at most once for each instruction");
        }
        if (v.isBranch()) {
            BranchPool.registerNormalBranchInstruction(v);
        } else if (v.isSwitch()) {
            BranchPool.registerSwitchInstruction(v);
        } else {
            throw new IllegalArgumentException("expect given instruction to be an actual branch");
        }
    }

    private static void registerNormalBranchInstruction(BytecodeInstruction v) {
        if (!v.isBranch()) {
            throw new IllegalArgumentException("normal branch instruction expceted");
        }
        if (registeredNormalBranches.containsKey(v)) {
            throw new IllegalArgumentException("instruction already registered as a normal branch");
        }
        registeredNormalBranches.put(v, ++branchCounter);
        Branch b = new Branch(v, branchCounter);
        BranchPool.addBranchToMap(b);
        branchIdMap.put(branchCounter, b);
        logger.info("Branch " + branchCounter + " at line " + v.getLineNumber());
    }

    private static void registerSwitchInstruction(BytecodeInstruction v) {
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("expect a switch instruction");
        }
        LabelNode defaultLabel = null;
        switch (v.getASMNode().getOpcode()) {
            case 170: {
                TableSwitchInsnNode tableSwitchNode = (TableSwitchInsnNode)v.getASMNode();
                BranchPool.registerTableSwitchCases(v, tableSwitchNode);
                defaultLabel = tableSwitchNode.dflt;
                break;
            }
            case 171: {
                LookupSwitchInsnNode lookupSwitchNode = (LookupSwitchInsnNode)v.getASMNode();
                BranchPool.registerLookupSwitchCases(v, lookupSwitchNode);
                defaultLabel = lookupSwitchNode.dflt;
                break;
            }
            default: {
                throw new IllegalStateException("expect ASMNode of a switch to either be a LOOKUP- or TABLESWITCH");
            }
        }
        BranchPool.registerDefaultCase(v, defaultLabel);
    }

    private static void registerDefaultCase(BytecodeInstruction v, LabelNode defaultLabel) {
        if (defaultLabel == null) {
            throw new IllegalStateException("expect variable to bet set");
        }
        Branch defaultBranch = BranchPool.createSwitchCaseBranch(v, null, defaultLabel);
        if (!defaultBranch.isSwitchCaseBranch() || !defaultBranch.isDefaultCase()) {
            throw new IllegalStateException("expect created branch to be a default case branch of a switch");
        }
    }

    private static void registerTableSwitchCases(BytecodeInstruction v, TableSwitchInsnNode tableSwitchNode) {
        int num = 0;
        for (int i = tableSwitchNode.min; i <= tableSwitchNode.max; ++i) {
            LabelNode targetLabel = (LabelNode)tableSwitchNode.labels.get(num);
            Branch switchBranch = BranchPool.createSwitchCaseBranch(v, i, targetLabel);
            if (!switchBranch.isSwitchCaseBranch() || !switchBranch.isActualCase()) {
                throw new IllegalStateException("expect created branch to be an actual case branch of a switch");
            }
            ++num;
        }
    }

    private static void registerLookupSwitchCases(BytecodeInstruction v, LookupSwitchInsnNode lookupSwitchNode) {
        for (int i = 0; i < lookupSwitchNode.keys.size(); ++i) {
            LabelNode targetLabel = (LabelNode)lookupSwitchNode.labels.get(i);
            Branch switchBranch = BranchPool.createSwitchCaseBranch(v, (Integer)lookupSwitchNode.keys.get(i), targetLabel);
            if (switchBranch.isSwitchCaseBranch() && switchBranch.isActualCase()) continue;
            throw new IllegalStateException("expect created branch to be an actual case branch of a switch");
        }
    }

    private static Branch createSwitchCaseBranch(BytecodeInstruction v, Integer caseValue, LabelNode targetLabel) {
        Branch switchBranch = new Branch(v, caseValue, targetLabel, ++branchCounter);
        BranchPool.registerSwitchBranch(v, switchBranch);
        BranchPool.addBranchToMap(switchBranch);
        branchIdMap.put(branchCounter, switchBranch);
        BranchPool.registerSwitchLabel(switchBranch, targetLabel);
        if (caseValue == null) {
            if (registeredDefaultCases.containsKey(v)) {
                throw new IllegalStateException("instruction already registered as a branch");
            }
            registeredDefaultCases.put(v, switchBranch);
        }
        if (!switchBranch.isSwitchCaseBranch()) {
            throw new IllegalStateException("expect created Branch to be a switch branch");
        }
        return switchBranch;
    }

    private static void registerSwitchLabel(Branch b, LabelNode targetLabel) {
        List<Branch> oldList;
        if (switchLabels.get(targetLabel) == null) {
            switchLabels.put(targetLabel, new ArrayList());
        }
        if ((oldList = switchLabels.get(targetLabel)).contains(b)) {
            throw new IllegalStateException("branch already registered for this switch label");
        }
        oldList.add(b);
        switchLabels.put(targetLabel, oldList);
    }

    private static void registerSwitchBranch(BytecodeInstruction v, Branch switchBranch) {
        List<Branch> oldList;
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (registeredSwitches.get(v) == null) {
            registeredSwitches.put(v, new ArrayList());
        }
        if ((oldList = registeredSwitches.get(v)).contains(switchBranch)) {
            throw new IllegalArgumentException("switch branch already registered  " + switchBranch.toString());
        }
        oldList.add(switchBranch);
        registeredSwitches.put(v, oldList);
    }

    private static void addBranchToMap(Branch b) {
        logger.info("Adding to map the branch {}", (Object)b);
        String className = b.getClassName();
        String methodName = b.getMethodName();
        if (!branchMap.containsKey(className)) {
            branchMap.put(className, new HashMap());
        }
        if (!branchMap.get(className).containsKey(methodName)) {
            branchMap.get(className).put(methodName, new ArrayList());
        }
        branchMap.get(className).get(methodName).add(b);
    }

    public static boolean isKnownAsBranch(BytecodeInstruction instruction) {
        return BranchPool.isKnownAsNormalBranchInstruction(instruction) || BranchPool.isKnownAsSwitchBranchInstruction(instruction);
    }

    public static boolean isKnownAsNormalBranchInstruction(BytecodeInstruction ins) {
        return registeredNormalBranches.containsKey(ins);
    }

    public static boolean isKnownAsSwitchBranchInstruction(BytecodeInstruction instruction) {
        return registeredSwitches.containsKey(instruction);
    }

    public static int getActualBranchIdForNormalBranchInstruction(BytecodeInstruction ins) {
        if (!BranchPool.isKnownAsNormalBranchInstruction(ins)) {
            throw new IllegalArgumentException("instruction not registered as a normal branch");
        }
        if (registeredNormalBranches.containsKey(ins)) {
            return registeredNormalBranches.get(ins);
        }
        throw new IllegalStateException("expect registeredNormalBranches to contain a key for each known normal branch instruction");
    }

    public static List<Branch> getCaseBranchesForSwitch(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!instruction.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (!BranchPool.isKnownAsSwitchBranchInstruction(instruction)) {
            throw new IllegalArgumentException("not registered as a switch instruction");
        }
        return registeredSwitches.get(instruction);
    }

    public static Branch getBranchForInstruction(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!BranchPool.isKnownAsNormalBranchInstruction(instruction)) {
            throw new IllegalArgumentException("expect given instruction to be known as a normal branch");
        }
        return BranchPool.getBranch(registeredNormalBranches.get(instruction));
    }

    public static List<Branch> getBranchForLabel(LabelNode label) {
        return switchLabels.get(label);
    }

    public static int getBranchCountForMethod(String className, String methodName) {
        if (branchMap.get(className) == null) {
            return 0;
        }
        if (branchMap.get(className).get(methodName) == null) {
            return 0;
        }
        return branchMap.get(className).get(methodName).size();
    }

    public static int getNonArtificialBranchCountForMethod(String className, String methodName) {
        if (branchMap.get(className) == null) {
            return 0;
        }
        if (branchMap.get(className).get(methodName) == null) {
            return 0;
        }
        int num = 0;
        for (Branch b : branchMap.get(className).get(methodName)) {
            if (b.isInstrumented()) continue;
            ++num;
        }
        return num;
    }

    public static int getBranchCountForClass(String className) {
        if (branchMap.get(className) == null) {
            return 0;
        }
        int total = 0;
        for (String method : branchMap.get(className).keySet()) {
            total += branchMap.get(className).get(method).size();
        }
        return total;
    }

    public static int getBranchCountForPrefix(String prefix) {
        int num = 0;
        for (String className : branchMap.keySet()) {
            if (!className.startsWith(prefix)) continue;
            logger.info("Found matching class for branch count: " + className + "/" + prefix);
            for (String method : branchMap.get(className).keySet()) {
                num += branchMap.get(className).get(method).size();
            }
        }
        return num;
    }

    public static int getBranchCountForMemberClasses(String prefix) {
        int num = 0;
        for (String className : branchMap.keySet()) {
            if (!className.equals(prefix) && !className.startsWith(prefix + "$")) continue;
            logger.info("Found matching class for branch count: " + className + "/" + prefix);
            for (String method : branchMap.get(className).keySet()) {
                num += branchMap.get(className).get(method).size();
            }
        }
        return num;
    }

    public static int getBranchCounter() {
        return branchCounter;
    }

    public static int getNumArtificialBranches() {
        int num = 0;
        for (Branch b : branchIdMap.values()) {
            if (!b.isInstrumented()) continue;
            ++num;
        }
        return num;
    }

    public static Branch getBranch(int branchId) {
        return branchIdMap.get(branchId);
    }

    public static Collection<Branch> getAllBranches() {
        return branchIdMap.values();
    }

    public static Set<String> getBranchlessMethods(String className) {
        if (!branchlessMethods.containsKey(className)) {
            return new HashSet<String>();
        }
        return branchlessMethods.get(className).keySet();
    }

    public static Set<String> getBranchlessMethodsPrefix(String className) {
        HashSet<String> methods = new HashSet<String>();
        for (String name : branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            methods.addAll(branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public static Set<String> getBranchlessMethodsMemberClasses(String className) {
        HashSet<String> methods = new HashSet<String>();
        for (String name : branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            methods.addAll(branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public static int getBranchlessMethodLineNumber(String className, String methodName) {
        if (branchlessMethods.get(className) != null && branchlessMethods.get(className).get(className + "." + methodName) != null) {
            return branchlessMethods.get(className).get(className + "." + methodName);
        }
        return branchlessMethods.get(className).get(className + "." + methodName);
    }

    public static Set<String> getBranchlessMethods() {
        HashSet<String> methods = new HashSet<String>();
        for (String name : branchlessMethods.keySet()) {
            methods.addAll(branchlessMethods.get(name).keySet());
        }
        return methods;
    }

    public static int getNumBranchlessMethods(String className) {
        if (!branchlessMethods.containsKey(className)) {
            return 0;
        }
        return branchlessMethods.get(className).size();
    }

    public static int getNumBranchlessMethodsPrefix(String className) {
        int num = 0;
        for (String name : branchlessMethods.keySet()) {
            if (!name.startsWith(className)) continue;
            num += branchlessMethods.get(name).size();
        }
        return num;
    }

    public static int getNumBranchlessMethodsMemberClasses(String className) {
        int num = 0;
        for (String name : branchlessMethods.keySet()) {
            if (!name.equals(className) && !name.startsWith(className + "$")) continue;
            num += branchlessMethods.get(name).size();
        }
        return num;
    }

    public static int getNumBranchlessMethods() {
        int num = 0;
        for (String name : branchlessMethods.keySet()) {
            num += branchlessMethods.get(name).size();
        }
        return num;
    }

    public static Set<String> knownClasses() {
        HashSet<String> r = new HashSet<String>();
        r.addAll(branchMap.keySet());
        r.addAll(branchlessMethods.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Known classes: " + r);
        }
        return r;
    }

    public static Set<String> knownMethods(String className) {
        HashSet<String> r = new HashSet<String>();
        Map<String, List<Branch>> methods = branchMap.get(className);
        if (methods != null) {
            r.addAll(methods.keySet());
        }
        return r;
    }

    public static List<Branch> retrieveBranchesInMethod(String className, String methodName) {
        ArrayList<Branch> r = new ArrayList<Branch>();
        if (branchMap.get(className) == null) {
            return r;
        }
        List<Branch> branches = branchMap.get(className).get(methodName);
        if (branches != null) {
            r.addAll(branches);
        }
        return r;
    }

    public static Branch getDefaultBranchForSwitch(BytecodeInstruction v) {
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (!BranchPool.isKnownAsSwitchBranchInstruction(v)) {
            throw new IllegalArgumentException("instruction not known to be a switch instruction");
        }
        if (!registeredDefaultCases.containsKey(v)) {
            throw new IllegalArgumentException("there is no registered default case for this instruction");
        }
        return registeredDefaultCases.get(v);
    }

    public static int getRealBranches(String className) {
        int real = 0;
        for (String methodName : branchMap.get(className).keySet()) {
            for (Branch b : branchMap.get(className).get(methodName)) {
                if (b.getInstruction().isForcedBranch()) continue;
                ++real;
            }
        }
        return real;
    }

    public static void reset() {
        branchCounter = 0;
        branchMap.clear();
        branchlessMethods.clear();
        branchIdMap.clear();
        registeredNormalBranches.clear();
        registeredSwitches.clear();
        registeredDefaultCases.clear();
        switchLabels.clear();
    }

    public static void clear() {
        branchCounter = 0;
        branchMap.clear();
        branchIdMap.clear();
        branchlessMethods.clear();
        switchLabels.clear();
        registeredDefaultCases.clear();
        registeredNormalBranches.clear();
        registeredSwitches.clear();
    }

    public static void clear(String className) {
        branchMap.remove(className);
        branchlessMethods.remove(className);
    }

    public static void clear(String className, String methodName) {
        int numBranches = 0;
        if (branchMap.containsKey(className)) {
            if (branchMap.get(className).containsKey(methodName)) {
                numBranches = branchMap.get(className).get(methodName).size();
            }
            branchMap.get(className).remove(methodName);
        }
        if (branchlessMethods.containsKey(className)) {
            branchlessMethods.get(className).remove(methodName);
        }
        logger.info("Resetting branchCounter from " + branchCounter + " to " + (branchCounter - numBranches));
        branchCounter -= numBranches;
    }
}

