/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.branch.OnlyBranchCoverageTestFitness;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyBranchCoverageFactory
extends AbstractFitnessFactory<OnlyBranchCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(OnlyBranchCoverageFactory.class);

    @Override
    public List<OnlyBranchCoverageTestFitness> getCoverageGoals() {
        long start = System.currentTimeMillis();
        ArrayList<OnlyBranchCoverageTestFitness> goals = new ArrayList<OnlyBranchCoverageTestFitness>();
        for (String className : BranchPool.knownClasses()) {
            MethodNameMatcher matcher = new MethodNameMatcher();
            for (String methodName : BranchPool.knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) {
                    logger.info("Method " + methodName + " does not match criteria. ");
                    continue;
                }
                for (Branch b : BranchPool.retrieveBranchesInMethod(className, methodName)) {
                    if (b.getInstruction().isForcedBranch()) continue;
                    goals.add(OnlyBranchCoverageFactory.createOnlyBranchCoverageTestFitness(b, true));
                    goals.add(OnlyBranchCoverageFactory.createOnlyBranchCoverageTestFitness(b, false));
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static OnlyBranchCoverageTestFitness createOnlyBranchCoverageTestFitness(ControlDependency cd) {
        return OnlyBranchCoverageFactory.createOnlyBranchCoverageTestFitness(cd.getBranch(), cd.getBranchExpressionValue());
    }

    public static OnlyBranchCoverageTestFitness createOnlyBranchCoverageTestFitness(Branch b, boolean branchExpressionValue) {
        return new OnlyBranchCoverageTestFitness(new BranchCoverageGoal(b, branchExpressionValue, b.getClassName(), b.getMethodName()));
    }
}

