/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.branch.OnlyBranchCoverageFactory;
import org.evosuite.coverage.branch.OnlyBranchCoverageTestFitness;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyBranchCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 8416765652693373609L;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public final int totalBranches;
    public final int totalGoals;
    public int maxCoveredBranches = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new HashMap<Integer, TestFitnessFunction>();
    private final Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new HashMap<Integer, TestFitnessFunction>();

    public OnlyBranchCoverageSuiteFitness() {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        if (prefix.isEmpty()) {
            prefix = Properties.TARGET_CLASS;
            this.totalBranches = BranchPool.getBranchCounter();
        } else {
            this.totalBranches = BranchPool.getBranchCountForPrefix(prefix);
        }
        this.totalGoals = 2 * this.totalBranches;
        logger.info("Total branch coverage goals: " + this.totalGoals);
        logger.info("Total branches: " + this.totalBranches);
        this.determineCoverageGoals();
    }

    private void determineCoverageGoals() {
        List<OnlyBranchCoverageTestFitness> goals = new OnlyBranchCoverageFactory().getCoverageGoals();
        for (OnlyBranchCoverageTestFitness goal : goals) {
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), goal);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), goal);
        }
    }

    private void handleConstructorExceptions(List<ExecutionResult> results, Map<String, Integer> callCount) {
        for (ExecutionResult result : results) {
            Integer exceptionPosition;
            StatementInterface statement;
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || !((statement = result.test.getStatement(exceptionPosition = result.getFirstPositionOfThrownException())) instanceof ConstructorStatement)) continue;
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (callCount.containsKey(name)) continue;
            callCount.put(name, 1);
        }
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Map<Integer, Integer> predicateCount, Map<String, Integer> callCount, Map<Integer, Double> trueDistance, Map<Integer, Double> falseDistance) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            for (Map.Entry<String, Integer> entry : result.getTrace().getMethodExecutionCount().entrySet()) {
                if (!callCount.containsKey(entry.getKey())) {
                    callCount.put(entry.getKey(), entry.getValue());
                    continue;
                }
                callCount.put(entry.getKey(), callCount.get(entry.getKey()) + entry.getValue());
            }
            for (Map.Entry<Object, Integer> entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
                if (!predicateCount.containsKey(entry.getKey())) {
                    predicateCount.put((Integer)entry.getKey(), entry.getValue());
                    continue;
                }
                predicateCount.put((Integer)entry.getKey(), predicateCount.get(entry.getKey()) + entry.getValue());
            }
            for (Map.Entry<Object, Number> entry : result.getTrace().getTrueDistances().entrySet()) {
                if (!trueDistance.containsKey(entry.getKey())) {
                    trueDistance.put((Integer)entry.getKey(), (Double)entry.getValue());
                } else {
                    trueDistance.put((Integer)entry.getKey(), Math.min(trueDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                if ((Double)entry.getValue() != 0.0) continue;
                result.test.addCoveredGoal(this.branchCoverageTrueMap.get(entry.getKey()));
            }
            for (Map.Entry<Object, Number> entry : result.getTrace().getFalseDistances().entrySet()) {
                if (!falseDistance.containsKey(entry.getKey())) {
                    falseDistance.put((Integer)entry.getKey(), (Double)entry.getValue());
                } else {
                    falseDistance.put((Integer)entry.getKey(), Math.min(falseDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                if ((Double)entry.getValue() != 0.0) continue;
                result.test.addCoveredGoal(this.branchCoverageFalseMap.get(entry.getKey()));
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<Integer, Double> trueDistance = new HashMap<Integer, Double>();
        HashMap<Integer, Double> falseDistance = new HashMap<Integer, Double>();
        HashMap<Integer, Integer> predicateCount = new HashMap<Integer, Integer>();
        HashMap<String, Integer> callCount = new HashMap<String, Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, predicateCount, callCount, trueDistance, falseDistance);
        this.handleConstructorExceptions(results, callCount);
        int numCoveredBranches = 0;
        for (Integer key : predicateCount.keySet()) {
            if (!trueDistance.containsKey(key) || !falseDistance.containsKey(key)) continue;
            int numExecuted = (Integer)predicateCount.get(key);
            double df = (Double)trueDistance.get(key);
            double dt = (Double)falseDistance.get(key);
            fitness = numExecuted == 1 ? (fitness += 1.0) : (fitness += OnlyBranchCoverageSuiteFitness.normalize(df) + OnlyBranchCoverageSuiteFitness.normalize(dt));
            if (df == 0.0) {
                ++numCoveredBranches;
            }
            if (dt != 0.0) continue;
            ++numCoveredBranches;
        }
        this.printStatusMessages(suite, numCoveredBranches, fitness += (double)(2 * (this.totalBranches - predicateCount.size())));
        int coverage = numCoveredBranches;
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coverage / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coverage);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalBranches * 2);
            fitness = this.totalBranches * 2;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coverage <= this.totalGoals) : "Covered " + coverage + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coverage == this.totalGoals) : "Fitness: " + fitness + ", " + "coverage: " + coverage + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredBranches, double fitness) {
        if (coveredBranches > this.maxCoveredBranches) {
            this.maxCoveredBranches = coveredBranches;
            logger.info("(Branches) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

