/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class AllDefsCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 1L;
    static List<? extends TestFitnessFunction> goals = TestSuiteGenerator.getFitnessFactory(Properties.Criterion.ALLDEFS).getCoverageGoals();
    public static int totalGoals = goals.size();

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        logger.trace("Calculating defuse fitness");
        TestSuiteChromosome suite = (TestSuiteChromosome)individual;
        List<ExecutionResult> results = this.runTestSuite(suite);
        double fitness = 0.0;
        HashSet<TestFitnessFunction> coveredGoals = new HashSet<TestFitnessFunction>();
        for (TestFitnessFunction testFitnessFunction : goals) {
            if (coveredGoals.contains(testFitnessFunction)) continue;
            double goalFitness = 2.0;
            for (ExecutionResult result : results) {
                TestChromosome tc = new TestChromosome();
                tc.setTestCase(result.test);
                double resultFitness = testFitnessFunction.getFitness(tc, result);
                if (resultFitness < goalFitness) {
                    goalFitness = resultFitness;
                }
                if (goalFitness != 0.0) continue;
                result.test.addCoveredGoal(testFitnessFunction);
                coveredGoals.add(testFitnessFunction);
                break;
            }
            fitness += goalFitness;
        }
        this.updateIndividual(this, individual, fitness);
        this.setSuiteCoverage(suite, coveredGoals);
        return fitness;
    }

    private void setSuiteCoverage(TestSuiteChromosome suite, Set<TestFitnessFunction> coveredGoals) {
        if (goals.size() > 0) {
            suite.setCoverage(this, (double)coveredGoals.size() / (double)goals.size());
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredGoals.size());
    }
}

