/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.graphs.cfg.BytecodeInstruction;

public class DefUseFactory {
    public static Use makeUse(BytecodeInstruction instruction) {
        if (!instruction.isUse()) {
            throw new IllegalArgumentException("expect wrap of a use to create one");
        }
        if (!DefUsePool.isKnown(instruction)) {
            throw new IllegalArgumentException("expect DefUsePool to know the given BytecodeInstruction: " + instruction.toString());
        }
        return new Use(instruction);
    }

    public static Definition makeDefinition(BytecodeInstruction instruction) {
        if (!instruction.isDefinition()) {
            throw new IllegalArgumentException("expect wrap of a definition to create one");
        }
        if (!DefUsePool.isKnown(instruction)) {
            throw new IllegalArgumentException("expect DefUsePool to know the given BytecodeInstruction");
        }
        return new Definition(instruction);
    }

    public static DefUse makeInstance(BytecodeInstruction instruction) {
        if (!instruction.isDefUse()) {
            throw new IllegalArgumentException("expect wrap of a defuse to create one");
        }
        if (instruction.isDefinition()) {
            return DefUseFactory.makeDefinition(instruction);
        }
        if (instruction.isUse()) {
            return DefUseFactory.makeUse(instruction);
        }
        throw new IllegalStateException("either isUse() or isDefinition() must return true on a defuse");
    }
}

