/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.evosuite.Properties;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.objectweb.asm.Type;

public class ExceptionCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1221020001417476348L;
    protected final String methodName;
    protected final Class<?> clazz;

    public ExceptionCoverageTestFitness(String methodName, Class<?> clazz) throws IllegalArgumentException {
        if (methodName == null || clazz == null) {
            throw new IllegalArgumentException("method name and exception class cannot be null");
        }
        this.clazz = clazz;
        this.methodName = methodName;
    }

    public String getMethod() {
        return this.methodName;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
            boolean notDeclared;
            Throwable t;
            if (i >= result.test.size() || (t = result.getExceptionThrownAtPosition(i)) instanceof SecurityException && Properties.SANDBOX || t.getStackTrace().length > 0 && t.getStackTrace()[0].getClassName().startsWith("org.evosuite.testcase") || t instanceof CodeUnderTestException) continue;
            String methodName = "";
            boolean sutException = false;
            if (result.test.getStatement(i) instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)result.test.getStatement(i);
                Method method = ms.getMethod().getMethod();
                methodName = method.getName() + Type.getMethodDescriptor(method);
                if (method.getDeclaringClass().equals(Properties.getTargetClass())) {
                    sutException = true;
                }
            } else if (result.test.getStatement(i) instanceof ConstructorStatement) {
                ConstructorStatement cs = (ConstructorStatement)result.test.getStatement(i);
                Constructor<?> constructor = cs.getConstructor().getConstructor();
                methodName = "<init>" + Type.getConstructorDescriptor(constructor);
                if (constructor.getDeclaringClass().equals(Properties.getTargetClass())) {
                    sutException = true;
                }
            }
            if (!(notDeclared = !result.test.getStatement(i).getDeclaredExceptions().contains(t.getClass())) || !sutException || !this.methodName.equals(methodName) || !this.clazz.equals(t.getClass())) continue;
            fitness = 0.0;
        }
        return fitness;
    }

    public String toString() {
        return this.methodName + this.clazz.getName();
    }

    public int hashCode() {
        int iConst = 17;
        return 53 * iConst + this.methodName.hashCode() * iConst + this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionCoverageTestFitness other = (ExceptionCoverageTestFitness)obj;
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.clazz.equals(other.getClazz());
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof ExceptionCoverageTestFitness) {
            ExceptionCoverageTestFitness otherMethodFitness = (ExceptionCoverageTestFitness)other;
            if (this.methodName.equals(otherMethodFitness.getMethod())) {
                if (this.clazz.equals(((ExceptionCoverageTestFitness)other).getClazz())) {
                    return 0;
                }
                return this.clazz.getName().compareTo(otherMethodFitness.getClazz().getName());
            }
            return this.methodName.compareTo(otherMethodFitness.getMethod());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return null;
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }
}

