/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchTestFitness;
import org.evosuite.setup.CallContext;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class IBranchSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -4745892521350308986L;
    private final List<IBranchTestFitness> branchGoals;
    private static double bestFitness = Double.MAX_VALUE;
    private final BranchCoverageSuiteFitness branchFitness = new BranchCoverageSuiteFitness();

    public IBranchSuiteFitness() {
        IBranchFitnessFactory factory = new IBranchFitnessFactory();
        this.branchGoals = factory.getCoverageGoals();
        for (IBranchTestFitness goal : this.branchGoals) {
            logger.info("Context goal: " + goal.toString());
        }
    }

    private Map<IBranchTestFitness, Double> getDefaultDistanceMap() {
        HashMap<IBranchTestFitness, Double> distanceMap = new HashMap<IBranchTestFitness, Double>();
        for (IBranchTestFitness goal : this.branchGoals) {
            distanceMap.put(goal, 1.0);
        }
        return distanceMap;
    }

    private Map<IBranchTestFitness, Integer> getDefaultCallCountMap() {
        HashMap<IBranchTestFitness, Integer> distanceMap = new HashMap<IBranchTestFitness, Integer>();
        for (IBranchTestFitness goal : this.branchGoals) {
            distanceMap.put(goal, 0);
        }
        return distanceMap;
    }

    private IBranchTestFitness getContextGoal(String classAndMethodName, CallContext context) {
        for (IBranchTestFitness goal : this.branchGoals) {
            String key;
            if (goal.getBranch() != null || !(key = goal.getTargetClass() + "." + goal.getTargetMethod()).equals(classAndMethodName) || !goal.getContext().matches(context)) continue;
            return goal;
        }
        return null;
    }

    private IBranchTestFitness getContextGoal(Integer branchId, CallContext context, boolean value) {
        for (IBranchTestFitness goal : this.branchGoals) {
            if (goal.getBranch() == null || goal.getBranch().getActualBranchId() != branchId.intValue() || !goal.getContext().matches(context) || goal.getValue() != value) continue;
            return goal;
        }
        throw new RuntimeException("Could not find goal for " + branchId + ", context " + context);
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        Map<IBranchTestFitness, Double> distanceMap = this.getDefaultDistanceMap();
        Map<IBranchTestFitness, Integer> callCount = this.getDefaultCallCountMap();
        for (ExecutionResult result : results) {
            double distance;
            IBranchTestFitness goal;
            for (Map.Entry<Integer, Map<CallContext, Double>> entry : result.getTrace().getTrueDistancesContext().entrySet()) {
                for (Map.Entry<CallContext, Double> entry2 : entry.getValue().entrySet()) {
                    goal = this.getContextGoal(entry.getKey(), entry2.getKey(), true);
                    distance = IBranchSuiteFitness.normalize(entry2.getValue());
                    if (!(distanceMap.get(goal) > distance)) continue;
                    distanceMap.put(goal, distance);
                }
            }
            for (Map.Entry<Integer, Map<CallContext, Double>> entry : result.getTrace().getFalseDistancesContext().entrySet()) {
                for (Map.Entry<CallContext, Double> entry3 : entry.getValue().entrySet()) {
                    goal = this.getContextGoal(entry.getKey(), entry3.getKey(), false);
                    distance = IBranchSuiteFitness.normalize(entry3.getValue());
                    if (!(distanceMap.get(goal) > distance)) continue;
                    distanceMap.put(goal, distance);
                }
            }
            for (Map.Entry<Integer, Map<CallContext, Number>> entry : result.getTrace().getPredicateContextExecutionCount().entrySet()) {
                for (Map.Entry<CallContext, Number> entry4 : entry.getValue().entrySet()) {
                    goal = this.getContextGoal(entry.getKey(), entry4.getKey(), true);
                    int count = (Integer)entry4.getValue();
                    if (callCount.get(goal) < count) {
                        callCount.put(goal, count);
                    }
                    goal = this.getContextGoal(entry.getKey(), entry4.getKey(), false);
                    count = (Integer)entry4.getValue();
                    if (callCount.get(goal) >= count) continue;
                    callCount.put(goal, count);
                }
            }
            for (Map.Entry<Object, Map<CallContext, Number>> entry : result.getTrace().getMethodContextCount().entrySet()) {
                for (Map.Entry<CallContext, Number> entry5 : entry.getValue().entrySet()) {
                    goal = this.getContextGoal((String)entry.getKey(), entry5.getKey());
                    if (goal == null) continue;
                    int count = (Integer)entry5.getValue();
                    if (callCount.get(goal) >= count) continue;
                    callCount.put(goal, count);
                }
            }
        }
        int numCoveredGoals = 0;
        for (IBranchTestFitness goal : this.branchGoals) {
            double d = distanceMap.get(goal);
            int n = callCount.get(goal);
            if (goal.getBranch() == null) {
                if (n == 0) {
                    fitness += 1.0;
                    continue;
                }
                ++numCoveredGoals;
                continue;
            }
            if (n > 0 && d == 0.0) {
                ++numCoveredGoals;
            }
            if (n == 1) {
                fitness += 0.5;
                continue;
            }
            if (n > 1) {
                fitness += d;
                continue;
            }
            fitness += 1.0;
        }
        if (!this.branchGoals.isEmpty()) {
            suite.setCoverage(this, (double)numCoveredGoals / (double)this.branchGoals.size());
        }
        suite.setNumOfCoveredGoals(this, numCoveredGoals);
        this.updateIndividual(this, suite, fitness);
        return fitness;
    }
}

