/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;

public class LineCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 3624503060256855484L;
    private final String className;
    private final String methodName;
    private final Integer line;

    public LineCoverageTestFitness(String className, String methodName, Integer line) throws IllegalArgumentException {
        if (className == null || methodName == null || line == null) {
            throw new IllegalArgumentException("className, methodName and line number cannot be null");
        }
        this.className = className;
        this.methodName = methodName;
        this.line = line;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    public Integer getLine() {
        return this.line;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        for (Integer coveredLine : result.getTrace().getCoveredLines()) {
            if (coveredLine.intValue() != this.line.intValue()) continue;
            fitness = 0.0;
            break;
        }
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    public String toString() {
        return this.className + (this.methodName == "" ? "" : "." + this.methodName) + ": Line " + this.line;
    }

    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode() + iConst + this.line.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineCoverageTestFitness other = (LineCoverageTestFitness)obj;
        if (this.className != other.className) {
            return false;
        }
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.line.intValue() == other.line.intValue();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other == null) {
            return 1;
        }
        if (other instanceof LineCoverageTestFitness) {
            LineCoverageTestFitness otherLineFitness = (LineCoverageTestFitness)other;
            if (this.className.compareTo(otherLineFitness.getClassName()) != 0) {
                return this.className.compareTo(otherLineFitness.getClassName());
            }
            if (this.methodName.compareTo(otherLineFitness.getMethod()) != 0) {
                return this.methodName.compareTo(otherLineFitness.getMethod());
            }
            return this.line.compareTo(otherLineFitness.getLine());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

