/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.objectweb.asm.Type;

public class MethodCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 3624503060256855484L;
    protected final String className;
    protected final String methodName;

    public MethodCoverageTestFitness(String className, String methodName) throws IllegalArgumentException {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("className and methodName cannot be null");
        }
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        for (StatementInterface stmt : result.test) {
            String methodName;
            String className;
            if (!(stmt instanceof MethodStatement) && !(stmt instanceof ConstructorStatement)) continue;
            if (stmt instanceof MethodStatement) {
                MethodStatement m = (MethodStatement)stmt;
                className = m.getMethod().getMethod().getDeclaringClass().getName();
                methodName = m.toString();
            } else {
                ConstructorStatement c = (ConstructorStatement)stmt;
                className = c.getConstructor().getDeclaringClass().getName();
                methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            }
            if (!this.className.equals(className) || !this.methodName.equals(methodName)) continue;
            fitness = 0.0;
            break;
        }
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    public String toString() {
        return this.className + "." + this.methodName;
    }

    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCoverageTestFitness other = (MethodCoverageTestFitness)obj;
        if (this.className != other.className) {
            return false;
        }
        return this.methodName.equals(other.methodName);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof MethodCoverageTestFitness) {
            MethodCoverageTestFitness otherMethodFitness = (MethodCoverageTestFitness)other;
            if (this.className.equals(otherMethodFitness.getClassName())) {
                return this.methodName.compareTo(otherMethodFitness.getMethod());
            }
            return this.className.compareTo(otherMethodFitness.getClassName());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

