/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodNoExceptionCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNoExceptionCoverageFactory
extends AbstractFitnessFactory<MethodNoExceptionCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(MethodNoExceptionCoverageFactory.class);

    @Override
    public List<MethodNoExceptionCoverageTestFitness> getCoverageGoals() {
        ArrayList<MethodNoExceptionCoverageTestFitness> goals = new ArrayList<MethodNoExceptionCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String className = Properties.TARGET_CLASS;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Class could not be loaded: " + className);
        }
        if (clazz != null) {
            Method[] allMethods;
            Constructor<?>[] allConstructors;
            for (Constructor<?> c : allConstructors = clazz.getDeclaredConstructors()) {
                if (!TestClusterGenerator.canUse(c)) continue;
                String methodName = "<init>" + Type.getConstructorDescriptor(c);
                logger.info("Adding goal for constructor " + className + "." + methodName);
                goals.add(new MethodNoExceptionCoverageTestFitness(className, methodName));
            }
            for (Method m : allMethods = clazz.getDeclaredMethods()) {
                if (!TestClusterGenerator.canUse(m)) continue;
                String methodName = m.getName() + Type.getMethodDescriptor(m);
                logger.info("Adding goal for method " + className + "." + methodName);
                goals.add(new MethodNoExceptionCoverageTestFitness(className, methodName));
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static MethodNoExceptionCoverageTestFitness createMethodTestFitness(String className, String method) {
        return new MethodNoExceptionCoverageTestFitness(className, method.substring(method.lastIndexOf(".") + 1));
    }

    public static MethodNoExceptionCoverageTestFitness createMethodTestFitness(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return MethodNoExceptionCoverageFactory.createMethodTestFitness(instruction.getClassName(), instruction.getMethodName());
    }
}

