/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodNoExceptionCoverageFactory;
import org.evosuite.coverage.method.MethodNoExceptionCoverageTestFitness;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodNoExceptionCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -704561530935529634L;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public final int totalMethods;
    public final Set<String> methods;
    public int maxCoveredMethods = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<String, TestFitnessFunction> methodNoExceptionCoverageMap = new HashMap<String, TestFitnessFunction>();

    public MethodNoExceptionCoverageSuiteFitness() {
        this.methods = new HashSet<String>();
        this.determineMethods();
        this.totalMethods = this.methods.size();
        logger.info("Total methods: " + this.totalMethods + ": " + this.methods);
        this.determineCoverageGoals();
    }

    private void determineMethods() {
        String className = Properties.TARGET_CLASS;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Class could not be loaded: " + className);
        }
        if (clazz != null) {
            Method[] allMethods;
            Constructor<?>[] allConstructors;
            for (Constructor<?> c : allConstructors = clazz.getDeclaredConstructors()) {
                if (!TestClusterGenerator.canUse(c)) continue;
                String descriptor = Type.getConstructorDescriptor(c);
                logger.info("Adding goal for constructor " + className + ".<init>" + descriptor);
                this.methods.add(c.getDeclaringClass().getName() + ".<init>" + descriptor);
            }
            for (Method m : allMethods = clazz.getDeclaredMethods()) {
                if (!TestClusterGenerator.canUse(m)) continue;
                String descriptor = Type.getMethodDescriptor(m);
                logger.info("Adding goal for method " + className + "." + m.getName() + descriptor);
                this.methods.add(m.getDeclaringClass().getName() + "." + m.getName() + descriptor);
            }
        }
    }

    private void determineCoverageGoals() {
        List<MethodNoExceptionCoverageTestFitness> goals = new MethodNoExceptionCoverageFactory().getCoverageGoals();
        for (MethodNoExceptionCoverageTestFitness goal : goals) {
            this.methodNoExceptionCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
        }
    }

    private void handleConstructorExceptions(List<ExecutionResult> results, Set<String> calledMethods) {
        for (ExecutionResult result : results) {
            Integer exceptionPosition;
            StatementInterface statement;
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || !((statement = result.test.getStatement(exceptionPosition = result.getFirstPositionOfThrownException())) instanceof ConstructorStatement)) continue;
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (!this.methodNoExceptionCoverageMap.containsKey(name) || calledMethods.contains(name)) continue;
            calledMethods.add(name);
        }
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Set<String> calledMethods) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            StatementInterface stmt;
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            List<Integer> exceptionPositions = MethodNoExceptionCoverageSuiteFitness.asSortedList(result.getPositionsWhereExceptionsWereThrown());
            Iterator i$ = result.test.iterator();
            while (i$.hasNext() && this.isValidPosition(exceptionPositions, (stmt = (StatementInterface)i$.next()).getPosition())) {
                String fullName;
                String methodName;
                String className;
                if (!(stmt instanceof MethodStatement) && !(stmt instanceof ConstructorStatement) || exceptionPositions.contains(stmt.getPosition())) continue;
                if (stmt instanceof MethodStatement) {
                    MethodStatement m = (MethodStatement)stmt;
                    className = m.getMethod().getMethod().getDeclaringClass().getName();
                    methodName = m.toString();
                } else {
                    ConstructorStatement c = (ConstructorStatement)stmt;
                    className = c.getConstructor().getDeclaringClass().getName();
                    methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
                }
                if (!this.methodNoExceptionCoverageMap.containsKey(fullName = className + "." + methodName)) continue;
                calledMethods.add(fullName);
                result.test.addCoveredGoal(this.methodNoExceptionCoverageMap.get(fullName));
            }
        }
        return hasTimeoutOrTestException;
    }

    private boolean isValidPosition(List<Integer> exceptionPositions, Integer position) {
        if (Properties.BREAK_ON_EXCEPTION) {
            return exceptionPositions.isEmpty() ? true : position > exceptionPositions.get(0);
        }
        return true;
    }

    private static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating method fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashSet<String> calledMethods = new HashSet<String>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, calledMethods);
        this.handleConstructorExceptions(results, calledMethods);
        int missingMethods = 0;
        for (String e : this.methods) {
            if (calledMethods.contains(e)) continue;
            fitness += 1.0;
            ++missingMethods;
        }
        int coveredMethods = calledMethods.size();
        assert (this.totalMethods == coveredMethods + missingMethods);
        this.printStatusMessages(suite, this.totalMethods - missingMethods, fitness);
        if (this.totalMethods > 0) {
            suite.setCoverage(this, (double)coveredMethods / (double)this.totalMethods);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredMethods);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalMethods);
            fitness = this.totalMethods;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coveredMethods <= this.totalMethods) : "Covered " + coveredMethods + " vs total goals " + this.totalMethods;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredMethods == this.totalMethods) : "Fitness: " + fitness + ", " + "coverage: " + coveredMethods + "/" + this.totalMethods;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredMethods, double fitness) {
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods No-Exc) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

