/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodTraceCoverageFactory;
import org.evosuite.coverage.method.MethodTraceCoverageTestFitness;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodTraceCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 4958063899628649732L;
    private static final Logger logger = LoggerFactory.getLogger(MethodTraceCoverageSuiteFitness.class);
    public final int totalMethods;
    private final Set<String> methods;
    public int maxCoveredMethods = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<String, TestFitnessFunction> methodCoverageMap = new HashMap<String, TestFitnessFunction>();

    public MethodTraceCoverageSuiteFitness() {
        this.methods = new HashSet<String>();
        this.determineMethods();
        this.totalMethods = this.methods.size();
        logger.info("Total methods: " + this.totalMethods + ": " + this.methods);
        this.determineCoverageGoals();
    }

    private void determineMethods() {
        String className = Properties.TARGET_CLASS;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz != null) {
            Method[] allMethods;
            Constructor<?>[] allConstructors;
            for (Constructor<?> c : allConstructors = clazz.getDeclaredConstructors()) {
                if (!TestClusterGenerator.canUse(c)) continue;
                String descriptor = Type.getConstructorDescriptor(c);
                logger.info("Adding goal for constructor " + className + ".<init>" + descriptor);
                this.methods.add(c.getDeclaringClass().getName() + ".<init>" + descriptor);
            }
            for (Method m : allMethods = clazz.getDeclaredMethods()) {
                if (!TestClusterGenerator.canUse(m)) continue;
                String descriptor = Type.getMethodDescriptor(m);
                logger.info("Adding goal for method " + className + "." + m.getName() + descriptor);
                this.methods.add(m.getDeclaringClass().getName() + "." + m.getName() + descriptor);
            }
        }
    }

    private void determineCoverageGoals() {
        List<MethodTraceCoverageTestFitness> goals = new MethodTraceCoverageFactory().getCoverageGoals();
        for (MethodTraceCoverageTestFitness goal : goals) {
            this.methodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
        }
    }

    private void handleConstructorExceptions(List<ExecutionResult> results, Map<String, Integer> callCount) {
        for (ExecutionResult result : results) {
            Integer exceptionPosition;
            StatementInterface statement;
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || !((statement = result.test.getStatement(exceptionPosition = result.getFirstPositionOfThrownException())) instanceof ConstructorStatement)) continue;
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (!this.methodCoverageMap.containsKey(name) || callCount.containsKey(name)) continue;
            callCount.put(name, 1);
        }
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Map<String, Integer> callCount) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
            }
            for (Map.Entry<String, Integer> entry : result.getTrace().getMethodExecutionCount().entrySet()) {
                if (!this.methodCoverageMap.containsKey(entry.getKey())) continue;
                if (!callCount.containsKey(entry.getKey())) {
                    callCount.put(entry.getKey(), entry.getValue());
                } else {
                    callCount.put(entry.getKey(), callCount.get(entry.getKey()) + entry.getValue());
                }
                result.test.addCoveredGoal(this.methodCoverageMap.get(entry.getKey()));
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating method fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        HashMap<String, Integer> callCount = new HashMap<String, Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, callCount);
        this.handleConstructorExceptions(results, callCount);
        logger.info("CallCount: " + callCount.keySet().toString() + " (length=" + callCount.keySet().size() + ")");
        int missingMethods = 0;
        for (String e : this.methods) {
            if (callCount.containsKey(e)) continue;
            logger.info("Method not covered in trace: " + e);
            fitness += 1.0;
            ++missingMethods;
        }
        logger.debug("Fitness: " + fitness);
        logger.debug("Number of missing methods: " + missingMethods);
        this.printStatusMessages(suite, this.totalMethods - missingMethods, fitness);
        int coverage = callCount.keySet().size();
        if (this.totalMethods > 0) {
            logger.debug("Coverage: " + (double)coverage / (double)this.totalMethods);
            suite.setCoverage(this, (double)coverage / (double)this.totalMethods);
        } else {
            logger.debug("Coverage (0 methods): 1.0");
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coverage);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalMethods);
            fitness = this.totalMethods;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coverage <= this.totalMethods) : "Covered " + coverage + " vs total goals " + this.totalMethods;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coverage == this.totalMethods) : "Fitness: " + fitness + ", " + "coverage: " + coverage + "/" + this.totalMethods;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredMethods, double fitness) {
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

