/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodCall;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;

public class MethodTraceCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -8880071948317243336L;
    protected final String className;
    protected final String methodName;

    public MethodTraceCoverageTestFitness(String className, String methodName) throws IllegalArgumentException {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("className and methodName cannot be null");
        }
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        for (MethodCall call : result.getTrace().getMethodCalls()) {
            if (!call.className.equals(this.className) || !call.methodName.equals(this.methodName)) continue;
            fitness = 0.0;
            break;
        }
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    public String toString() {
        return this.className + "." + this.methodName;
    }

    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodTraceCoverageTestFitness other = (MethodTraceCoverageTestFitness)obj;
        if (this.className != other.className) {
            return false;
        }
        return this.methodName.equals(other.methodName);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof MethodTraceCoverageTestFitness) {
            MethodTraceCoverageTestFitness otherMethodFitness = (MethodTraceCoverageTestFitness)other;
            if (this.className.equals(otherMethodFitness.getClassName())) {
                return this.methodName.compareTo(otherMethodFitness.getMethod());
            }
            return this.className.compareTo(otherMethodFitness.getClassName());
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

