/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;

public class Mutation
implements Comparable<Mutation> {
    private final int id;
    private final String className;
    private final String methodName;
    private final String mutationName;
    private final BytecodeInstruction original;
    private final InsnList mutation;
    private final InsnList infection;
    private final int lineNo;

    public Mutation(String className, String methodName, String mutationName, int id, BytecodeInstruction original, AbstractInsnNode mutation, InsnList distance) {
        this.className = className;
        this.methodName = methodName;
        this.mutationName = mutationName;
        this.id = id;
        this.original = original;
        this.mutation = new InsnList();
        this.mutation.add(mutation);
        this.infection = distance;
        this.lineNo = original.getLineNumber();
    }

    public Mutation(String className, String methodName, String mutationName, int id, BytecodeInstruction original, InsnList mutation, InsnList distance) {
        this.className = className;
        this.methodName = methodName;
        this.mutationName = mutationName;
        this.id = id;
        this.original = original;
        this.mutation = mutation;
        this.infection = distance;
        this.lineNo = original.getLineNumber();
    }

    public int getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public int getOperandSize() {
        return 0;
    }

    public String getMutationName() {
        return this.id + ": " + this.mutationName + ", line " + this.original.getLineNumber();
    }

    public Set<BranchCoverageGoal> getControlDependencies() {
        HashSet<BranchCoverageGoal> goals = new HashSet<BranchCoverageGoal>();
        for (ControlDependency cd : this.original.getControlDependencies()) {
            BranchCoverageGoal goal = new BranchCoverageGoal(cd, this.className, this.methodName);
            goals.add(goal);
        }
        return goals;
    }

    public AbstractInsnNode getOriginalNode() {
        return this.original.getASMNode();
    }

    public InsnList getMutation() {
        return this.mutation;
    }

    public InsnList getInfectionDistance() {
        return this.infection;
    }

    public static InsnList getDefaultInfectionDistance() {
        InsnList defaultDistance = new InsnList();
        defaultDistance.add(new LdcInsnNode(0.0));
        return defaultDistance;
    }

    public String toString() {
        return "Mutation " + this.id + ": " + this.className + "." + this.methodName + ":" + this.lineNo + " - " + this.mutationName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.lineNo;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.mutationName == null ? 0 : this.mutationName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mutation other = (Mutation)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lineNo != other.lineNo) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.mutationName == null ? other.mutationName != null : !this.mutationName.equals(other.mutationName));
    }

    @Override
    public int compareTo(Mutation o) {
        return this.lineNo - o.lineNo;
    }
}

