/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.coverage.mutation.WeakMutationTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationTestPool
implements SearchListener {
    private static final Logger logger = LoggerFactory.getLogger(MutationTestPool.class);
    private static Map<Mutation, TestChromosome> testMap = new HashMap<Mutation, TestChromosome>();
    private static final List<Mutation> allMutants = MutationPool.getMutants();
    private static final List<MutationTestFitness> allMutantFitnessFunctions = new ArrayList<MutationTestFitness>();

    public static Set<Mutation> getUncoveredMutants() {
        HashSet<Mutation> mutants = new HashSet<Mutation>();
        for (Mutation m : allMutants) {
            if (MutationTimeoutStoppingCondition.isDisabled(m) || MutationTestPool.isCovered(m)) continue;
            mutants.add(m);
        }
        return mutants;
    }

    public static boolean isCovered(Mutation mutation) {
        return testMap.containsKey(mutation);
    }

    public static Set<MutationTestFitness> getUncoveredFitnessFunctions() {
        HashSet<MutationTestFitness> mutants = new HashSet<MutationTestFitness>();
        for (MutationTestFitness m : allMutantFitnessFunctions) {
            if (MutationTimeoutStoppingCondition.isDisabled(m.getMutation()) || MutationTestPool.isCovered(m.getMutation())) continue;
            mutants.add(m);
        }
        return mutants;
    }

    public static int getCoveredMutants() {
        return testMap.size();
    }

    public static void addTest(Mutation mutation, TestChromosome test) {
        testMap.put(mutation, test);
    }

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void iteration(GeneticAlgorithm<?> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<?> algorithm) {
        TestSuiteChromosome solution = (TestSuiteChromosome)algorithm.getBestIndividual();
        logger.info("Search finished with size " + solution.size());
        for (TestChromosome test : testMap.values()) {
            solution.addTest(test);
        }
        logger.info("Adding mutation tests to size " + solution.size());
    }

    @Override
    public void fitnessEvaluation(Chromosome individual) {
    }

    @Override
    public void modification(Chromosome individual) {
    }

    static {
        for (Mutation m : allMutants) {
            if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.WEAKMUTATION)) {
                allMutantFitnessFunctions.add(new WeakMutationTestFitness(m));
                continue;
            }
            allMutantFitnessFunctions.add(new StrongMutationTestFitness(m));
        }
        Randomness.shuffle(allMutantFitnessFunctions);
    }
}

