/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.ArrayTraceEntry;
import org.evosuite.assertion.ArrayTraceObserver;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.assertion.ComparisonTraceObserver;
import org.evosuite.assertion.InspectorTraceEntry;
import org.evosuite.assertion.InspectorTraceObserver;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.assertion.NullTraceObserver;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.assertion.PrimitiveFieldTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.assertion.PrimitiveTraceObserver;
import org.evosuite.coverage.TestCoverageGoal;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationExecutionResult;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.ExecutionTrace;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;

public class StrongMutationTestFitness
extends MutationTestFitness {
    private static final long serialVersionUID = -262199037689935052L;
    protected static Class<?>[] observerClasses = new Class[]{PrimitiveTraceEntry.class, ComparisonTraceEntry.class, InspectorTraceEntry.class, PrimitiveFieldTraceEntry.class, NullTraceEntry.class, ArrayTraceEntry.class};
    protected static AssertionTraceObserver<?>[] observers = new AssertionTraceObserver[]{new PrimitiveTraceObserver(), new ComparisonTraceObserver(), new InspectorTraceObserver(), new PrimitiveFieldTraceObserver(), new NullTraceObserver(), new ArrayTraceObserver()};

    public StrongMutationTestFitness(Mutation mutation) {
        super(mutation);
        for (AssertionTraceObserver<?> observer : observers) {
            logger.debug("StrongMutation adding observer " + observer);
            TestCaseExecutor.getInstance().addObserver(observer);
        }
    }

    @Override
    public ExecutionResult runTest(TestCase test) {
        return StrongMutationTestFitness.runTest(test, null);
    }

    public static ExecutionResult runTest(TestCase test, Mutation mutant) {
        ExecutionResult result = new ExecutionResult(test, mutant);
        try {
            if (mutant != null) {
                logger.debug("Executing test for mutant " + mutant.getId() + ": \n" + test.toCode());
            } else {
                logger.debug("Executing test witout mutant");
            }
            if (mutant != null) {
                MutationObserver.activateMutation(mutant);
            }
            result = TestCaseExecutor.getInstance().execute(test);
            if (mutant != null) {
                MutationObserver.deactivateMutation(mutant);
            }
            int num = test.size();
            if (!result.noThrownExceptions()) {
                num = result.getFirstPositionOfThrownException();
            }
            MaxStatementsStoppingCondition.statementsExecuted(num);
            int i = 0;
            for (AssertionTraceObserver<?> observer : observers) {
                result.setTrace(observer.getTrace(), observerClasses[i++]);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    private MutationExecutionResult getMutationResult(ExecutionResult originalResult, ExecutionResult mutationResult) {
        MutationExecutionResult result = new MutationExecutionResult();
        if (TestCoverageGoal.hasTimeout(mutationResult)) {
            logger.debug("Found timeout in mutant!");
            MutationTimeoutStoppingCondition.timeOut(this.mutation);
            result.setHasTimeout(true);
        }
        if (!originalResult.noThrownExceptions() && mutationResult.noThrownExceptions()) {
            result.setHasTimeout(true);
        }
        int numAssertions = this.getNumAssertions(originalResult, mutationResult);
        result.setNumAssertions(numAssertions);
        if (numAssertions == 0) {
            double impact = this.getSumDistance(originalResult.getTrace(), mutationResult.getTrace());
            result.setImpact(impact);
        }
        return result;
    }

    private Set<String> getDifference(Map<String, Map<String, Map<Integer, Integer>>> orig, Map<String, Map<String, Map<Integer, Integer>>> mutant) {
        HashMap handled = new HashMap();
        HashSet<String> differ = new HashSet<String>();
        for (Map.Entry<String, Map<String, Map<Integer, Integer>>> entry : orig.entrySet()) {
            if (!handled.containsKey(entry.getKey())) {
                handled.put(entry.getKey(), new HashSet());
            }
            for (Map.Entry<String, Map<Integer, Integer>> method_entry : entry.getValue().entrySet()) {
                if (!mutant.containsKey(entry.getKey())) {
                    logger.debug("Found class difference: " + entry.getKey());
                    differ.add(entry.getKey());
                    continue;
                }
                if (!mutant.get(entry.getKey()).containsKey(method_entry.getKey())) {
                    logger.debug("Found method difference: " + method_entry.getKey());
                    differ.add(entry.getKey() + "." + method_entry.getKey());
                    continue;
                }
                for (Map.Entry<Integer, Integer> line_entry : method_entry.getValue().entrySet()) {
                    if (!mutant.get(entry.getKey()).get(method_entry.getKey()).containsKey(line_entry.getKey())) {
                        logger.debug("Found line difference: " + line_entry.getKey() + ": " + line_entry.getValue());
                        differ.add(entry.getKey() + "." + method_entry.getKey() + ":" + line_entry.getKey());
                        continue;
                    }
                    if (mutant.get(entry.getKey()).get(method_entry.getKey()).get(line_entry.getKey()).equals(line_entry.getValue())) continue;
                    differ.add(entry.getKey() + "." + method_entry.getKey() + ":" + line_entry.getKey());
                    logger.debug("Found line difference: " + line_entry.getKey() + ": " + line_entry.getValue());
                }
                if (method_entry.getValue().equals(mutant.get(entry.getKey()).get(method_entry.getKey()))) continue;
                differ.add(entry.getKey() + "." + method_entry.getKey());
                logger.debug("Found other difference: " + entry.getKey());
            }
        }
        return differ;
    }

    private int getCoverageDifference(Map<String, Map<String, Map<Integer, Integer>>> orig, Map<String, Map<String, Map<Integer, Integer>>> mutant) {
        Set<String> differ = this.getDifference(orig, mutant);
        differ.addAll(this.getDifference(mutant, orig));
        return differ.size();
    }

    private double getSumDistance(ExecutionTrace orig_trace, ExecutionTrace mutant_trace) {
        logger.debug("Calculating coverage impact");
        double coverage_impact = this.getCoverageDifference(orig_trace.getCoverageData(), mutant_trace.getCoverageData());
        logger.debug("Coverage impact: " + coverage_impact);
        logger.debug("Calculating data impact");
        double data_impact = this.getCoverageDifference(orig_trace.getReturnData(), mutant_trace.getReturnData());
        logger.debug("Data impact: " + data_impact);
        double branch_impact = 0.0;
        for (Integer predicate : orig_trace.getCoveredPredicates()) {
            branch_impact = mutant_trace.hasTrueDistance(predicate) ? (branch_impact += StrongMutationTestFitness.normalize(Math.abs(orig_trace.getTrueDistance(predicate) - mutant_trace.getTrueDistance(predicate)))) : (branch_impact += 1.0);
            if (mutant_trace.hasFalseDistance(predicate)) {
                branch_impact += StrongMutationTestFitness.normalize(Math.abs(orig_trace.getFalseDistance(predicate) - mutant_trace.getFalseDistance(predicate)));
                continue;
            }
            branch_impact += 1.0;
        }
        logger.debug("Branch impact: " + branch_impact);
        return StrongMutationTestFitness.normalize(coverage_impact) + StrongMutationTestFitness.normalize(data_impact) + branch_impact;
    }

    private int getNumAssertions(ExecutionResult orig_result, ExecutionResult mutant_result) {
        int num = 0;
        if (orig_result.test.size() == 0) {
            return 0;
        }
        for (Class<?> observerClass : observerClasses) {
            OutputTrace<?> trace = mutant_result.getTrace(observerClass);
            OutputTrace<?> orig = orig_result.getTrace(observerClass);
            if (orig == null) {
                String msg = "No trace for " + observerClass + ". Traces: ";
                for (OutputTrace<?> t : orig_result.getTraces()) {
                    msg = msg + " " + t.toString();
                }
                logger.error(msg);
                continue;
            }
            num += orig.numDiffer(trace);
        }
        logger.debug("Found " + num + " assertions!");
        return num;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 0.0;
        double executionDistance = this.diameter;
        executionDistance = !result.getTrace().getTouchedMutants().contains(this.mutation.getId()) ? this.getExecutionDistance(result) : 0.0;
        double infectionDistance = 1.0;
        double impactDistance = 1.0;
        if (executionDistance <= 0.0) {
            assert (result.getTrace() != null);
            assert (result.getTrace().getTouchedMutants().contains(this.mutation.getId()));
            infectionDistance = StrongMutationTestFitness.normalize(result.getTrace().getMutationDistance(this.mutation.getId()));
            logger.debug("Infection distance for mutation = " + infectionDistance);
            if (infectionDistance <= 0.0) {
                logger.debug("Running test on mutant " + this.mutation.getId());
                MutationExecutionResult mutationResult = individual.getLastExecutionResult(this.mutation);
                if (mutationResult == null) {
                    ExecutionResult exResult = StrongMutationTestFitness.runTest(individual.getTestCase(), this.mutation);
                    mutationResult = this.getMutationResult(result, exResult);
                    individual.setLastExecutionResult(mutationResult, this.mutation);
                }
                if (mutationResult.hasTimeout()) {
                    logger.debug("Found timeout in mutant!");
                    MutationTimeoutStoppingCondition.timeOut(this.mutation);
                }
                if (mutationResult.hasException()) {
                    logger.debug("Mutant raises exception");
                }
                if (mutationResult.getNumAssertions() == 0) {
                    double impact = mutationResult.getImpact();
                    logger.debug("Impact is " + impact + " (" + 1.0 / (1.0 + impact) + ")");
                    impactDistance = 1.0 / (1.0 + impact);
                } else {
                    logger.debug("Assertions: " + mutationResult.getNumAssertions());
                    impactDistance = 0.0;
                }
                logger.debug("Impact distance for mutation = " + fitness);
            }
        }
        fitness = impactDistance + infectionDistance + executionDistance;
        logger.debug("Individual fitness: " + impactDistance + " + " + infectionDistance + " + " + executionDistance + " = " + fitness);
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        return fitness;
    }

    @Override
    public String toString() {
        return "Strong " + this.mutation.toString();
    }

    @Override
    public boolean isCovered(TestChromosome individual, ExecutionResult result) {
        boolean covered = false;
        if (individual.getLastExecutionResult(this.mutation) == null) {
            boolean bl = covered = this.getFitness(individual, result) == 0.0;
        }
        if (!covered && individual.getLastExecutionResult(this.mutation) != null) {
            MutationExecutionResult mutantResult = individual.getLastExecutionResult(this.mutation);
            if (mutantResult.hasTimeout()) {
                covered = true;
            } else if (mutantResult.hasException() && result.noThrownExceptions()) {
                covered = true;
            }
        }
        return covered;
    }
}

