/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationSuiteFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class WeakMutationSuiteFitness
extends MutationSuiteFitness {
    private static final long serialVersionUID = -1812256816400338180L;

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        if (this.mutationGoals.size() == 0) {
            this.updateIndividual(this, individual, 0.0);
            ((TestSuiteChromosome)individual).setCoverage(this, 1.0);
            ((TestSuiteChromosome)individual).setNumOfCoveredGoals(this, 0);
            return 0.0;
        }
        List<ExecutionResult> results = this.runTestSuite(individual);
        logger.debug("Calculating branch fitness: ");
        double fitness = this.branchFitness.getFitness(individual);
        HashMap<Integer, Double> mutant_distance = new HashMap<Integer, Double>();
        HashSet<Integer> touchedMutants = new HashSet<Integer>();
        for (ExecutionResult result : results) {
            touchedMutants.addAll(result.getTrace().getTouchedMutants());
            for (Map.Entry<Integer, Double> entry : result.getTrace().getMutationDistances().entrySet()) {
                if (!mutant_distance.containsKey(entry.getKey())) {
                    mutant_distance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                mutant_distance.put(entry.getKey(), Math.min((Double)mutant_distance.get(entry.getKey()), entry.getValue()));
            }
        }
        fitness += (double)(MutationPool.getMutantCounter() - touchedMutants.size());
        int covered = 0;
        for (Double distance : mutant_distance.values()) {
            if (distance < 0.0) {
                logger.warn("Distance is " + distance + " / " + Integer.MAX_VALUE + " / " + Integer.MIN_VALUE);
                distance = 0.0;
            }
            fitness += WeakMutationSuiteFitness.normalize(distance);
            if (distance != 0.0) continue;
            ++covered;
        }
        this.updateIndividual(this, individual, fitness);
        ((TestSuiteChromosome)individual).setCoverage(this, 1.0 * (double)covered / (double)this.mutationGoals.size());
        ((TestSuiteChromosome)individual).setNumOfCoveredGoals(this, covered);
        return fitness;
    }
}

