/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestChromosome;

public class WeakMutationTestFitness
extends MutationTestFitness {
    private static final long serialVersionUID = 7468742584904580204L;

    public WeakMutationTestFitness(Mutation mutation) {
        super(mutation);
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 0.0;
        double executionDistance = this.diameter;
        executionDistance = !result.getTrace().wasMutationTouched(this.mutation.getId()) ? this.getExecutionDistance(result) : 0.0;
        double infectionDistance = 1.0;
        if (executionDistance <= 0.0) {
            if (executionDistance < 0.0) {
                logger.warn("Execution distance less than 0! " + this.mutation);
                assert (false) : "Invalid execution distance on mutation " + this.mutation;
                executionDistance = 0.0;
            }
            assert (result.getTrace() != null);
            assert (result.getTrace().wasMutationTouched(this.mutation.getId()));
            infectionDistance = WeakMutationTestFitness.normalize(result.getTrace().getMutationDistance(this.mutation.getId()));
            logger.debug("Infection distance for mutation = " + infectionDistance);
        }
        fitness = infectionDistance + executionDistance;
        logger.debug("Individual fitness:  + " + infectionDistance + " + " + executionDistance + " = " + fitness);
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        return fitness;
    }

    @Override
    public String toString() {
        return "Weak " + this.mutation.toString();
    }
}

