/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.output;

import java.util.HashSet;
import java.util.Map;
import org.evosuite.coverage.output.OutputCoverageFactory;
import org.evosuite.coverage.output.OutputCoverageGoal;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.objectweb.asm.Type;

public class OutputCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1383064944691491355L;
    private final OutputCoverageGoal goal;

    public OutputCoverageTestFitness(OutputCoverageGoal goal) throws IllegalArgumentException {
        if (goal == null) {
            throw new IllegalArgumentException("goal cannot be null");
        }
        this.goal = goal;
    }

    public static HashSet<String> listCoveredGoals(Map<MethodStatement, Object> returnValues) {
        HashSet<String> results = new HashSet<String>();
        for (Map.Entry<MethodStatement, Object> entry : returnValues.entrySet()) {
            String className = entry.getKey().getMethod().getMethod().getDeclaringClass().getName();
            String methodName = entry.getKey().getMethod().getName() + Type.getMethodDescriptor(entry.getKey().getMethod().getMethod());
            Type returnType = Type.getReturnType(entry.getKey().getMethod().getMethod());
            Object returnValue = entry.getValue();
            String goalSuffix = "";
            switch (returnType.getSort()) {
                case 1: {
                    if (((Boolean)returnValue).booleanValue()) {
                        goalSuffix = "true";
                        break;
                    }
                    goalSuffix = "false";
                    break;
                }
                case 2: {
                    char c = ((Character)returnValue).charValue();
                    if (Character.isAlphabetic(c)) {
                        goalSuffix = "alpha";
                        break;
                    }
                    if (Character.isDigit(c)) {
                        goalSuffix = "digit";
                        break;
                    }
                    goalSuffix = "other";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    assert (returnValue instanceof Number);
                    double value = ((Number)returnValue).doubleValue();
                    if (value < 0.0) {
                        goalSuffix = "negative";
                        break;
                    }
                    if (value == 0.0) {
                        goalSuffix = "zero";
                        break;
                    }
                    goalSuffix = "positive";
                    break;
                }
                case 9: 
                case 10: {
                    if (returnValue == null) {
                        goalSuffix = "null";
                        break;
                    }
                    goalSuffix = "nonnull";
                    break;
                }
            }
            if (goalSuffix.isEmpty()) continue;
            results.add(OutputCoverageFactory.goalString(className, methodName, goalSuffix));
        }
        return results;
    }

    public String getClassName() {
        return this.goal.getClassName();
    }

    public String getMethod() {
        return this.goal.getMethodName();
    }

    public String getType() {
        return this.goal.getType();
    }

    public String getValueDescriptor() {
        return this.goal.getValueDescriptor();
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        HashSet<String> strGoals = OutputCoverageTestFitness.listCoveredGoals(result.getReturnValues());
        for (String strGoal : strGoals) {
            if (!strGoal.equals(this.goal.toString())) continue;
            fitness = 0.0;
        }
        this.updateIndividual(this, individual, fitness);
        return fitness;
    }

    public String toString() {
        return this.goal.toString();
    }

    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.goal.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputCoverageTestFitness other = (OutputCoverageTestFitness)obj;
        return this.goal.equals(other.goal);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof OutputCoverageTestFitness) {
            OutputCoverageTestFitness otherOutputFitness = (OutputCoverageTestFitness)other;
            return this.goal.compareTo(otherOutputFitness.goal);
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

