/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;

public class StatementCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 4609519536866911970L;
    protected BytecodeInstruction goalInstruction;
    protected List<BranchCoverageTestFitness> branchFitnesses = new ArrayList<BranchCoverageTestFitness>();
    BranchCoverageTestFitness lastCoveringFitness = null;

    public StatementCoverageTestFitness(BytecodeInstruction goalInstruction) {
        if (goalInstruction == null) {
            throw new IllegalArgumentException("null given");
        }
        this.goalInstruction = goalInstruction;
        Set<ControlDependency> cds = goalInstruction.getControlDependencies();
        for (ControlDependency cd : cds) {
            BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
            this.branchFitnesses.add(fitness);
        }
        if (goalInstruction.isRootBranchDependent()) {
            this.branchFitnesses.add(BranchCoverageFactory.createRootBranchTestFitness(goalInstruction));
        }
        if (cds.isEmpty() && !goalInstruction.isRootBranchDependent()) {
            throw new IllegalStateException("expect control dependencies to be empty only for root dependent instructions: " + this.toString());
        }
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("an instruction is at least on the root branch of it's method");
        }
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("expect to know at least one fitness for goalInstruction");
        }
        double r = Double.MAX_VALUE;
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            double newFitness = branchFitness.getFitness(individual, result);
            if (newFitness == 0.0) {
                this.lastCoveringFitness = branchFitness;
                return 0.0;
            }
            if (!(newFitness < r)) continue;
            r = newFitness;
        }
        this.lastCoveringFitness = null;
        return r;
    }

    public BranchCoverageTestFitness getLastCoveringFitness() {
        return this.lastCoveringFitness;
    }

    public String toString() {
        return "Statement Goal: " + this.goalInstruction.getMethodName() + " " + this.goalInstruction.toString();
    }

    public String explain() {
        StringBuilder r = new StringBuilder();
        r.append("StatementCoverageTestFitness for ");
        r.append(this.goalInstruction.toString());
        r.append(" in " + this.goalInstruction.getMethodName());
        r.append("\n");
        r.append("CDS:\n");
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            r.append("\t" + branchFitness.toString());
        }
        return r.toString();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof StatementCoverageTestFitness) {
            return this.goalInstruction.compareTo(((StatementCoverageTestFitness)other).goalInstruction);
        }
        return 0;
    }

    @Override
    public String getTargetClass() {
        return this.goalInstruction.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.goalInstruction.getMethodName();
    }
}

