/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.utils.PublicCloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Chromosome
implements Comparable<Chromosome>,
Serializable,
PublicCloneable<Chromosome> {
    private static final long serialVersionUID = -6921897301005213358L;
    protected static final Logger logger = LoggerFactory.getLogger(Chromosome.class);
    private LinkedHashMap<FitnessFunction<?>, Double> fitnesses = new LinkedHashMap();
    private LinkedHashMap<FitnessFunction<?>, Double> lastFitnesses = new LinkedHashMap();
    protected boolean solution = false;
    private boolean changed = true;
    private LinkedHashMap<FitnessFunction<?>, Double> coverages = new LinkedHashMap();
    private LinkedHashMap<FitnessFunction<?>, Integer> numsCoveredGoals = new LinkedHashMap();
    protected int age = 0;
    protected int rank = -1;
    protected double distance = 0.0;

    protected Chromosome() {
    }

    public double getFitness() {
        if (Properties.COMPOSITIONAL_FITNESS) {
            double sumFitnesses = 0.0;
            for (FitnessFunction<?> fitnessFunction : this.fitnesses.keySet()) {
                sumFitnesses += this.fitnesses.get(fitnessFunction).doubleValue();
            }
            return sumFitnesses;
        }
        return this.fitnesses.isEmpty() ? 0.0 : this.fitnesses.get(this.fitnesses.keySet().iterator().next());
    }

    public double getFitness(FitnessFunction<?> ff) {
        return this.fitnesses.containsKey(ff) ? this.fitnesses.get(ff) : 0.0;
    }

    public Map<FitnessFunction<?>, Double> getFitnesses() {
        return this.fitnesses;
    }

    public Map<FitnessFunction<?>, Double> getLastFitnesses() {
        return this.lastFitnesses;
    }

    public void setFitnesses(Map<FitnessFunction<?>, Double> fits) {
        this.fitnesses.clear();
        this.fitnesses.putAll(fits);
    }

    public void setLastFitnesses(Map<FitnessFunction<?>, Double> lastFits) {
        this.lastFitnesses.clear();
        this.lastFitnesses.putAll(lastFits);
    }

    public void addFitness(FitnessFunction<?> ff) {
        if (ff.isMaximizationFunction()) {
            this.addFitness(ff, 0.0, 0.0, 0);
        } else {
            this.addFitness(ff, Double.MAX_VALUE, 0.0, 0);
        }
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue) {
        this.addFitness(ff, fitnessValue, 0.0, 0);
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue, double coverage) {
        this.fitnesses.put(ff, fitnessValue);
        this.lastFitnesses.put(ff, fitnessValue);
        this.coverages.put(ff, coverage);
        this.numsCoveredGoals.put(ff, 0);
    }

    public void addFitness(FitnessFunction<?> ff, double fitnessValue, double coverage, int numCoveredGoals) {
        this.fitnesses.put(ff, fitnessValue);
        this.lastFitnesses.put(ff, fitnessValue);
        this.coverages.put(ff, coverage);
        this.numsCoveredGoals.put(ff, numCoveredGoals);
    }

    public void setFitness(FitnessFunction<?> ff, double value) throws IllegalArgumentException {
        if (Double.compare(value, Double.NaN) == 0 || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Invalid value of Fitness: " + value + ", Fitness: " + ff.getClass().getName());
        }
        if (!this.fitnesses.containsKey(ff)) {
            this.lastFitnesses.put(ff, value);
            this.fitnesses.put(ff, value);
        } else {
            this.lastFitnesses.put(ff, this.fitnesses.get(ff));
            this.fitnesses.put(ff, value);
        }
    }

    public boolean hasFitnessChanged() {
        for (FitnessFunction<?> ff : this.fitnesses.keySet()) {
            if (this.fitnesses.get(ff).equals(this.lastFitnesses.get(ff))) continue;
            return true;
        }
        return false;
    }

    public boolean isSolution() {
        return this.solution;
    }

    public void setSolution(boolean value) {
        this.solution = value;
    }

    @Override
    public abstract Chromosome clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public int compareTo(Chromosome c) {
        int i = (int)Math.signum(this.getFitness() - c.getFitness());
        if (i == 0) {
            return this.compareSecondaryObjective(c);
        }
        return i;
    }

    public abstract int compareSecondaryObjective(Chromosome var1);

    public abstract void mutate();

    public void crossOver(Chromosome other, int position) throws ConstructionFailedException {
        this.crossOver(other, position, position);
    }

    public abstract void crossOver(Chromosome var1, int var2, int var3) throws ConstructionFailedException;

    public abstract boolean localSearch(LocalSearchObjective<? extends Chromosome> var1);

    public abstract int size();

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public double getCoverage() {
        if (Properties.COMPOSITIONAL_FITNESS) {
            double cov;
            double sum = 0.0;
            for (FitnessFunction<?> fitnessFunction : this.fitnesses.keySet()) {
                sum += this.coverages.get(fitnessFunction).doubleValue();
            }
            double d = cov = this.coverages.isEmpty() ? 0.0 : sum / (double)this.coverages.size();
            assert (cov >= 0.0 && cov <= 1.0) : "Incorrect coverage value " + cov + ". Expected value between 0 and 1";
            return cov;
        }
        return this.coverages.isEmpty() ? 0.0 : this.coverages.get(this.fitnesses.keySet().iterator().next());
    }

    public int getNumOfCoveredGoals() {
        if (Properties.COMPOSITIONAL_FITNESS) {
            int sum = 0;
            for (FitnessFunction<?> fitnessFunction : this.fitnesses.keySet()) {
                sum += this.numsCoveredGoals.get(fitnessFunction).intValue();
            }
            return sum;
        }
        return this.numsCoveredGoals.isEmpty() ? 0 : this.numsCoveredGoals.get(this.fitnesses.keySet().iterator().next());
    }

    public void setNumsOfCoveredGoals(Map<FitnessFunction<?>, Integer> fits) {
        this.numsCoveredGoals.clear();
        this.numsCoveredGoals.putAll(fits);
    }

    public Map<FitnessFunction<?>, Integer> getNumsOfCoveredGoals() {
        return this.numsCoveredGoals;
    }

    public Map<FitnessFunction<?>, Double> getCoverages() {
        return this.coverages;
    }

    public void setCoverages(Map<FitnessFunction<?>, Double> coverages) {
        this.coverages.clear();
        this.coverages.putAll(coverages);
    }

    public double getCoverage(FitnessFunction<?> ff) {
        return this.coverages.containsKey(ff) ? this.coverages.get(ff) : 0.0;
    }

    public void setCoverage(FitnessFunction<?> ff, double coverage) {
        this.coverages.put(ff, coverage);
    }

    public double getNumOfCoveredGoals(FitnessFunction<?> ff) {
        return this.numsCoveredGoals.containsKey(ff) ? (double)this.numsCoveredGoals.get(ff).intValue() : 0.0;
    }

    public void setNumOfCoveredGoals(FitnessFunction<?> ff, int numCoveredGoals) {
        this.numsCoveredGoals.put(ff, numCoveredGoals);
    }

    public void updateAge(int generation) {
        this.age = generation;
    }

    public int getAge() {
        return this.age;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int r) {
        this.rank = r;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getFitnessInstanceOf(Class<?> clazz) {
        for (FitnessFunction<?> fitnessFunction : this.fitnesses.keySet()) {
            if (!clazz.isInstance(fitnessFunction)) continue;
            return this.fitnesses.get(fitnessFunction);
        }
        return 0.0;
    }

    public double getCoverageInstanceOf(Class<?> clazz) {
        for (FitnessFunction<?> fitnessFunction : this.coverages.keySet()) {
            if (!clazz.isInstance(fitnessFunction)) continue;
            return this.coverages.get(fitnessFunction);
        }
        return 0.0;
    }
}

