/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import org.evosuite.ga.Chromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FitnessFunction<T extends Chromosome>
implements Serializable {
    private static final long serialVersionUID = -8876797554111396910L;
    protected static final Logger logger = LoggerFactory.getLogger(FitnessFunction.class);

    protected void updateIndividual(FitnessFunction<?> ff, T individual, double fitness) {
        ((Chromosome)individual).setFitness(ff, fitness);
    }

    public abstract double getFitness(T var1);

    public static double normalize(double value) throws IllegalArgumentException {
        if (value < 0.0) {
            throw new IllegalArgumentException("Values to normalize cannot be negative");
        }
        if (Double.isInfinite(value)) {
            return 1.0;
        }
        return value / (1.0 + value);
    }

    public abstract boolean isMaximizationFunction();
}

