/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import org.evosuite.ga.Chromosome;

public abstract class ReplacementFunction
implements Serializable {
    private static final long serialVersionUID = 8507488475265387482L;
    protected boolean maximize = false;

    public ReplacementFunction(boolean maximize) {
        this.maximize = maximize;
    }

    protected boolean isBetter(Chromosome chromosome1, Chromosome chromosome2) {
        if (this.maximize) {
            return chromosome1.compareTo(chromosome2) > 0;
        }
        return chromosome1.compareTo(chromosome2) < 0;
    }

    protected boolean isBetterOrEqual(Chromosome chromosome1, Chromosome chromosome2) {
        if (this.maximize) {
            return chromosome1.compareTo(chromosome2) >= 0;
        }
        return chromosome1.compareTo(chromosome2) <= 0;
    }

    protected Chromosome getBest(Chromosome chromosome1, Chromosome chromosome2) {
        if (this.isBetter(chromosome1, chromosome2)) {
            return chromosome1;
        }
        return chromosome2;
    }

    public boolean keepOffspring(Chromosome parent1, Chromosome parent2, Chromosome offspring1, Chromosome offspring2) {
        if (this.maximize) {
            return this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2) >= 0;
        }
        return this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2) <= 0;
    }

    protected int compareBestOffspringToBestParent(Chromosome parent1, Chromosome parent2, Chromosome offspring1, Chromosome offspring2) {
        Chromosome bestOffspring = this.getBest(offspring1, offspring2);
        Chromosome bestParent = this.getBest(parent1, parent2);
        return bestOffspring.compareTo(bestParent);
    }

    @Deprecated
    public boolean keepOffspring(Chromosome parent, Chromosome offspring) {
        return this.isBetterOrEqual(offspring, parent);
    }
}

