/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.util.HashSet;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.DSELocalSearch;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.localsearch.StatementLocalSearch;
import org.evosuite.ga.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestMutationHistoryEntry;

public class AdaptiveTestCaseLocalSearch
extends TestCaseLocalSearch {
    @Override
    public boolean doSearch(TestChromosome individual, LocalSearchObjective<TestChromosome> objective) {
        Integer lastPos;
        double oldFitness = individual.getFitness();
        logger.info("Applying local search on test case");
        int lastPosition = individual.size() - 1;
        if (individual.getLastExecutionResult() != null && !individual.isChanged() && (lastPos = individual.getLastExecutionResult().getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        HashSet<Integer> targetPositions = new HashSet<Integer>();
        logger.info("Mutation history: " + individual.getMutationHistory().toString());
        logger.info("Checking {} mutations", (Object)individual.getMutationHistory().size());
        for (TestMutationHistoryEntry mutation : individual.getMutationHistory()) {
            if (LocalSearchBudget.getInstance().isFinished()) break;
            if (mutation.getMutationType() != TestMutationHistoryEntry.TestMutation.DELETION && mutation.getStatement().getPosition() <= lastPosition && mutation.getStatement() instanceof PrimitiveStatement) {
                logger.info("Found suitable mutation: " + mutation);
                if (!individual.getTestCase().hasReferences(mutation.getStatement().getReturnValue()) && !mutation.getStatement().getReturnClass().equals(Properties.getTargetClass())) {
                    logger.info("Return value of statement  is not referenced and not SUT, not doing local search");
                    continue;
                }
                if (Properties.LOCAL_SEARCH_DSE == Properties.DSEType.TEST) {
                    targetPositions.add(mutation.getStatement().getPosition());
                    continue;
                }
                StatementLocalSearch search = StatementLocalSearch.getLocalSearchFor(mutation.getStatement());
                if (search == null) continue;
                search.doSearch(individual, mutation.getStatement().getPosition(), objective);
                continue;
            }
            logger.info("Unsuitable mutation");
        }
        if (!targetPositions.isEmpty()) {
            logger.info("Yes, now applying the search at positions {}!", (Object)targetPositions);
            DSELocalSearch dse = new DSELocalSearch();
            boolean dseWasSuccessfull = dse.doSearch(individual, targetPositions, objective);
        }
        individual.getMutationHistory().clear();
        LocalSearchBudget.getInstance().countLocalSearchOnTest();
        assert (individual.getFitness() <= oldFitness);
        return objective.getFitnessFunction().isMaximizationFunction() ? oldFitness < individual.getFitness() : oldFitness > individual.getFitness();
    }
}

