/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.localsearch.StatementLocalSearch;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.ConstraintCache;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSELocalSearch
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(DSELocalSearch.class);

    @Override
    public boolean doSearch(TestChromosome test, Set<Integer> statements, LocalSearchObjective<TestChromosome> objective) {
        logger.info("APPLYING DSE EEEEEEEEEEEEEEEEEEEEEEE");
        logger.info(test.getTestCase().toCode());
        logger.info("Starting symbolic execution");
        TestChromosome clone = (TestChromosome)test.clone();
        List<BranchCondition> conditions = ConcolicExecution.executeConcolic((DefaultTestCase)test.getTestCase().clone());
        logger.info("Done symbolic execution");
        for (BranchCondition c : conditions) {
            logger.info(" -> " + c.getLocalConstraint());
        }
        HashSet<VariableReference> targets = new HashSet<VariableReference>();
        for (Integer position : statements) {
            targets.add(test.getTestCase().getStatement(position).getReturnValue());
        }
        logger.info("Checking {} conditions", (Object)conditions.size());
        int num = 0;
        for (BranchCondition condition : conditions) {
            logger.info("Current condition: " + num + "/" + conditions.size() + ": " + condition.getLocalConstraint());
            ++num;
            Constraint<?> currentConstraint = condition.getLocalConstraint();
            if (!this.isRelevant(currentConstraint, targets)) {
                logger.info("Is not relevant for " + targets);
                continue;
            }
            logger.info("Is relevant for " + targets);
            List<Constraint<?>> constraints = new LinkedList();
            constraints.addAll(condition.getReachingConstraints());
            Constraint<?> targetConstraint = condition.getLocalConstraint().negate();
            constraints.add(targetConstraint);
            constraints = this.reduce(constraints);
            logger.info("Trying to solve: ");
            for (Constraint<?> c : constraints) {
                logger.info("  " + c);
            }
            DSEStats.reportNewConstraints(constraints);
            Solver solver = SolverFactory.getInstance().buildNewSolver();
            long startSolvingTime = System.currentTimeMillis();
            Map<String, Object> values = ConstraintCache.getInstance().solve(solver, constraints);
            long estimatedSolvingTime = System.currentTimeMillis() - startSolvingTime;
            DSEStats.reportNewSolvingTime(estimatedSolvingTime);
            if (values != null && !values.isEmpty()) {
                logger.info("Found solution");
                DSEStats.reportNewSAT();
                TestCase oldTest = test.getTestCase();
                TestCase newTest = this.updateTest(oldTest, values);
                logger.info("New test: " + newTest.toCode());
                test.setTestCase(newTest);
                test.clearCachedResults();
                if (objective.hasImproved(test)) {
                    DSEStats.reportNewTestUseful();
                    logger.info("Solution improves fitness, finishing DSE");
                    return true;
                }
                DSEStats.reportNewTestUnuseful();
                if (Properties.DSE_KEEP_ALL_TESTS) {
                    logger.info("Solution does not improve fitness, keeping solution");
                    objective.retainPartialSolution((TestChromosome)test.clone());
                }
                test.setTestCase(oldTest);
                if (clone.getLastExecutionResult() == null) continue;
                test.setLastExecutionResult(clone.getLastExecutionResult());
                continue;
            }
            logger.info("Found no solution");
            DSEStats.reportNewUNSAT();
        }
        return false;
    }

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        HashSet<Integer> statements = new HashSet<Integer>();
        statements.add(statement);
        return this.doSearch(test, statements, objective);
    }

    private boolean isRelevant(Constraint<?> constraint, Set<VariableReference> targets) {
        Set<Variable<?>> variables = constraint.getVariables();
        HashSet<String> targetNames = new HashSet<String>();
        for (VariableReference variableReference : targets) {
            targetNames.add(variableReference.getName());
        }
        for (Variable variable : variables) {
            if (!targetNames.contains(variable.getName())) continue;
            return true;
        }
        return false;
    }

    private TestCase updateTest(TestCase test, Map<String, Object> values) {
        TestCase newTest = test.clone();
        for (String key : values.keySet()) {
            Object val = values.get(key);
            if (val != null) {
                PrimitiveStatement<?> p;
                String name;
                Number value;
                logger.info("New value: " + key + ": " + val);
                if (val instanceof Long) {
                    value = (Long)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    if (p.getValue().getClass().equals(Character.class)) {
                        p.setValue(Character.valueOf((char)((Long)value).intValue()));
                        continue;
                    }
                    if (p.getValue().getClass().equals(Long.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Integer.class)) {
                        p.setValue(((Long)value).intValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Short.class)) {
                        p.setValue(((Long)value).shortValue());
                        continue;
                    }
                    if (p.getValue().getClass().equals(Boolean.class)) {
                        p.setValue(((Long)value).intValue() > 0);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Byte.class)) {
                        p.setValue(((Long)value).byteValue() > 0);
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + p.getValue().getClass() + val);
                    continue;
                }
                if (val instanceof String) {
                    String name2 = key.replace("__SYM", "");
                    PrimitiveStatement<?> p2 = this.getStatement(newTest, name2);
                    assert (p2 != null) : "Could not find variable " + name2 + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p2.getValue().getClass().equals(Character.class)) {
                        p2.setValue(Character.valueOf((char)Integer.parseInt(val.toString())));
                        continue;
                    }
                    p2.setValue(val.toString());
                    continue;
                }
                if (val instanceof Double) {
                    value = (Double)val;
                    name = key.replace("__SYM", "");
                    p = this.getStatement(newTest, name);
                    assert (p != null) : "Could not find variable " + name + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                    if (p.getValue().getClass().equals(Double.class)) {
                        p.setValue(value);
                        continue;
                    }
                    if (p.getValue().getClass().equals(Float.class)) {
                        p.setValue(Float.valueOf(((Double)value).floatValue()));
                        continue;
                    }
                    logger.warn("New value is of an unsupported type: " + val);
                    continue;
                }
                logger.debug("New value is of an unsupported type: " + val);
                continue;
            }
            logger.debug("New value is null");
        }
        return newTest;
    }

    private List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = this.getVariables(target);
        LinkedList coi = new LinkedList();
        if (dependencies.size() <= 0) {
            return coi;
        }
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = this.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (StatementInterface statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        DSELocalSearch.getVariables(constraint.getLeftOperand(), variables);
        DSELocalSearch.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    public static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        variables.addAll(expr.getVariables());
    }
}

