/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.util.HashSet;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.DSELocalSearch;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.localsearch.StatementLocalSearch;
import org.evosuite.ga.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;

public class StandardTestCaseLocalSearch
extends TestCaseLocalSearch {
    @Override
    public boolean doSearch(TestChromosome individual, LocalSearchObjective<TestChromosome> objective) {
        Integer lastPos;
        logger.info("Test before local search: " + individual.getTestCase().toCode());
        double oldFitness = individual.getFitness();
        boolean result = false;
        int lastPosition = individual.size() - 1;
        if (individual.getLastExecutionResult() != null && !individual.isChanged() && (lastPos = individual.getLastExecutionResult().getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        TestCase test = individual.getTestCase();
        HashSet<Integer> targetPositions = new HashSet<Integer>();
        for (int i = lastPosition; i >= 0 && !LocalSearchBudget.getInstance().isFinished(); --i) {
            if (i >= individual.size()) {
                logger.warn("Test size decreased unexpectedly during local search, aborting local search");
                logger.warn(individual.getTestCase().toCode());
                break;
            }
            if (!test.hasReferences(test.getStatement(i).getReturnValue()) && !test.getStatement(i).getReturnClass().equals(Properties.getTargetClass())) {
                logger.info("Return value of statement " + i + " is not referenced and not SUT, not doing local search");
                continue;
            }
            if (Properties.LOCAL_SEARCH_DSE == Properties.DSEType.TEST) {
                targetPositions.add(i);
                continue;
            }
            StatementLocalSearch search = StatementLocalSearch.getLocalSearchFor(test.getStatement(i));
            if (search == null) continue;
            logger.info("Applying local search of type " + search.getClass() + " to statement " + test.getStatement(i) + " / " + individual.getTestCase().getStatement(i));
            if (search.doSearch(individual, i, objective)) {
                result = true;
            }
            logger.info("Old position was: " + i + ", adjusting to: " + (i + search.getPositionDelta()));
            i += search.getPositionDelta();
            test = individual.getTestCase();
        }
        if (!targetPositions.isEmpty()) {
            logger.info("Yes, now applying the search at positions {}!", (Object)targetPositions);
            DSELocalSearch dse = new DSELocalSearch();
            result = dse.doSearch(individual, targetPositions, objective);
        }
        LocalSearchBudget.getInstance().countLocalSearchOnTest();
        assert (individual.getFitness() <= oldFitness);
        logger.info("Test after local search: " + individual.getTestCase().toCode());
        return result;
    }
}

