/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteLocalSearchObjective
implements LocalSearchObjective<TestChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteLocalSearchObjective.class);
    private final TestSuiteFitnessFunction fitness;
    private final TestSuiteChromosome suite;
    private Set<TestChromosome> partialSolutions = new HashSet<TestChromosome>();
    private final int testIndex;
    private double lastFitness;
    private double lastCoverage;

    public TestSuiteLocalSearchObjective(TestSuiteFitnessFunction fitness, TestSuiteChromosome suite, int index) {
        this.fitness = fitness;
        this.suite = suite;
        this.testIndex = index;
        this.lastFitness = fitness.getFitness(suite);
        this.lastCoverage = suite.getCoverage(fitness);
    }

    public void verifyFitnessValue() {
        assert (this.lastFitness == this.suite.getFitness(this.fitness));
        double currentFitness1 = this.fitness.getFitness(this.suite);
        for (TestChromosome test : this.suite.getTestChromosomes()) {
            test.setChanged(true);
        }
        double currentFitness2 = this.fitness.getFitness(this.suite);
        assert (this.lastFitness == currentFitness1) : "Fitness values; " + this.lastFitness + ", " + currentFitness1 + ", " + currentFitness2;
        assert (currentFitness1 == currentFitness2) : "Fitness values; " + this.lastFitness + ", " + currentFitness1 + ", " + currentFitness2;
    }

    @Override
    public boolean hasImproved(TestChromosome individual) {
        return this.hasChanged(individual) < 0;
    }

    @Override
    public boolean hasNotWorsened(TestChromosome individual) {
        return this.hasChanged(individual) < 1;
    }

    private boolean isFitnessBetter(double newFitness, double oldFitness) {
        if (this.fitness.isMaximizationFunction()) {
            return newFitness > oldFitness;
        }
        return newFitness < oldFitness;
    }

    private boolean isFitnessWorse(double newFitness, double oldFitness) {
        if (this.fitness.isMaximizationFunction()) {
            return newFitness < oldFitness;
        }
        return newFitness > oldFitness;
    }

    @Override
    public int hasChanged(TestChromosome individual) {
        individual.setChanged(true);
        this.suite.setTestChromosome(this.testIndex, individual);
        LocalSearchBudget.getInstance().countFitnessEvaluation();
        double newFitness = this.fitness.getFitness(this.suite);
        if (this.isFitnessBetter(newFitness, this.lastFitness)) {
            logger.info("Local search improved fitness from " + this.lastFitness + " to " + newFitness);
            this.lastFitness = newFitness;
            this.lastCoverage = this.suite.getCoverage(this.fitness);
            this.suite.setFitness(this.fitness, this.lastFitness);
            return -1;
        }
        if (this.isFitnessWorse(newFitness, this.lastFitness)) {
            logger.info("Local search worsened fitness from " + this.lastFitness + " to " + newFitness);
            this.suite.setFitness(this.fitness, this.lastFitness);
            this.suite.setCoverage(this.fitness, this.lastCoverage);
            return 1;
        }
        logger.info("Local search did not change fitness of " + this.lastFitness);
        this.lastCoverage = this.suite.getCoverage(this.fitness);
        return 0;
    }

    public TestSuiteFitnessFunction getFitnessFunction() {
        return this.fitness;
    }

    public Set<TestChromosome> getPartialSolutions() {
        return this.partialSolutions;
    }

    @Override
    public void retainPartialSolution(TestChromosome individual) {
        this.partialSolutions.add(individual);
    }
}

