/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.localsearch.DefaultLocalSearchObjective;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.metaheuristics.SearchAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.populationlimit.IndividualPopulationLimit;
import org.evosuite.ga.populationlimit.PopulationLimit;
import org.evosuite.ga.stoppingconditions.MaxGenerationStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneticAlgorithm<T extends Chromosome>
implements SearchAlgorithm,
Serializable {
    private static final long serialVersionUID = 5155609385855093435L;
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    protected List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();
    protected SelectionFunction<T> selectionFunction = new RankSelection();
    protected CrossOverFunction crossoverFunction = new SinglePointCrossOver();
    protected List<T> population = new ArrayList<T>();
    protected ChromosomeFactory<T> chromosomeFactory;
    protected transient Set<SearchListener> listeners = new HashSet<SearchListener>();
    protected transient Set<StoppingCondition> stoppingConditions = new HashSet<StoppingCondition>();
    protected Set<BloatControlFunction> bloatControl = new HashSet<BloatControlFunction>();
    protected LocalSearchObjective<T> localObjective = null;
    protected PopulationLimit populationLimit = new IndividualPopulationLimit();
    protected int currentIteration = 0;
    protected double localSearchProbability = Properties.LOCAL_SEARCH_PROBABILITY;

    public GeneticAlgorithm(ChromosomeFactory<T> factory) {
        this.chromosomeFactory = factory;
        this.addStoppingCondition(new MaxGenerationStoppingCondition());
        if (Properties.LOCAL_SEARCH_RATE > 0) {
            this.addListener(LocalSearchBudget.getInstance());
        }
    }

    protected abstract void evolve();

    protected boolean shouldApplyLocalSearch() {
        if (Properties.LOCAL_SEARCH_RATE <= 0) {
            return false;
        }
        return this.getAge() % Properties.LOCAL_SEARCH_RATE == 0 && Randomness.nextDouble() <= this.localSearchProbability;
    }

    protected void applyLocalSearch() {
        if (!this.shouldApplyLocalSearch()) {
            return;
        }
        logger.debug("Applying local search");
        LocalSearchBudget.getInstance().localSearchStarted();
        boolean improvement = false;
        for (Chromosome individual : this.population) {
            if (this.isFinished()) break;
            if (LocalSearchBudget.getInstance().isFinished()) {
                logger.debug("Local search budget used up, exiting local search");
                break;
            }
            if (!individual.localSearch(this.localObjective)) continue;
            improvement = true;
        }
        if (improvement) {
            DSEStats.reportNewIncrease();
            this.localSearchProbability = Math.pow(1.0 + (1.0 - this.localSearchProbability) / this.localSearchProbability * Math.exp(-Properties.LOCAL_SEARCH_ADAPTATION_RATE), -1.0);
            logger.debug("Increasing probability of applying LS to " + this.localSearchProbability);
        } else {
            DSEStats.reportNewDecrease();
            this.localSearchProbability = Math.pow(1.0 + (1.0 - this.localSearchProbability) / this.localSearchProbability * Math.exp(Properties.LOCAL_SEARCH_ADAPTATION_RATE), -1.0);
            logger.debug("Decreasing probability of applying LS to " + this.localSearchProbability);
        }
    }

    public abstract void initializePopulation();

    @Override
    public abstract void generateSolution();

    protected void generateInitialPopulation(int population_size) {
        this.generateRandomPopulation(population_size - this.population.size());
    }

    protected void starveToLimit(int limit) {
        if (Properties.STARVE_BY_FITNESS) {
            this.starveByFitness(limit);
        } else {
            this.starveRandomly(limit);
        }
    }

    protected void starveRandomly(int limit) {
        while (this.population.size() > limit) {
            int removePos = Randomness.nextInt() % this.population.size();
            this.population.remove(removePos);
        }
    }

    protected void starveByFitness(int limit) {
        this.calculateFitnessAndSortPopulation();
        for (int i = this.population.size() - 1; i >= limit; --i) {
            this.population.remove(i);
        }
    }

    protected void generateRandomPopulation(int population_size) {
        logger.debug("Creating random population");
        for (int i = 0; i < population_size; ++i) {
            T individual = this.chromosomeFactory.getChromosome();
            for (FitnessFunction<T> fitnessFunction : this.fitnessFunctions) {
                ((Chromosome)individual).addFitness(fitnessFunction);
            }
            this.population.add(individual);
            if (this.isFinished()) break;
        }
        logger.debug("Created " + this.population.size() + " individuals");
    }

    public void clearPopulation() {
        logger.debug("Resetting population");
        this.population.clear();
    }

    public void addFitnessFunction(FitnessFunction<T> function) {
        this.fitnessFunctions.add(function);
        if (this.localObjective == null) {
            this.localObjective = new DefaultLocalSearchObjective(function);
        }
    }

    public void addFitnessFunctions(List<FitnessFunction<T>> functions) {
        for (FitnessFunction<T> function : functions) {
            this.addFitnessFunction(function);
        }
    }

    public FitnessFunction<T> getFitnessFunction() {
        return this.fitnessFunctions.get(0);
    }

    public List<FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }

    public int getNumberOfFitnessFunctions() {
        return this.fitnessFunctions.size();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (Chromosome c : this.population) {
            str.append("\n  - test " + i);
            for (FitnessFunction<T> ff : this.fitnessFunctions) {
                DecimalFormat df = new DecimalFormat("#.#####");
                str.append(", " + ff.getClass().getSimpleName().replace("CoverageSuiteFitness", "") + " " + df.format(c.getFitness(ff)));
            }
            ++i;
        }
        return str.toString();
    }

    public void setSelectionFunction(SelectionFunction<T> function) {
        this.selectionFunction = function;
    }

    public SelectionFunction<T> getSelectionFunction() {
        return this.selectionFunction;
    }

    public void setBloatControl(BloatControlFunction bloat_control) {
        this.bloatControl.clear();
        this.addBloatControl(bloat_control);
    }

    public void addBloatControl(BloatControlFunction bloat_control) {
        this.bloatControl.add(bloat_control);
    }

    public boolean isTooLong(Chromosome chromosome) {
        for (BloatControlFunction b : this.bloatControl) {
            if (!b.isTooLong(chromosome)) continue;
            return true;
        }
        return false;
    }

    public int getAge() {
        return this.currentIteration;
    }

    protected void calculateFitnessAndSortPopulation() {
        logger.debug("Calculating fitness for " + this.population.size() + " individuals");
        Iterator<T> iterator = this.population.iterator();
        while (iterator.hasNext()) {
            Chromosome c = (Chromosome)iterator.next();
            if (this.isFinished()) {
                if (!c.isChanged()) continue;
                iterator.remove();
                continue;
            }
            for (FitnessFunction<Chromosome> fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(c);
                this.notifyEvaluation(c);
            }
        }
        this.sortPopulation();
    }

    public int getPopulationSize() {
        return this.population.size();
    }

    protected List<T> elitism() {
        logger.debug("Elitism with ELITE = " + Properties.ELITE);
        ArrayList<Chromosome> elite = new ArrayList<Chromosome>();
        for (int i = 0; i < Properties.ELITE; ++i) {
            logger.trace("Copying individual " + i + " with fitness " + ((Chromosome)this.population.get(i)).getFitness());
            elite.add(((Chromosome)this.population.get(i)).clone());
        }
        logger.trace("Done.");
        return elite;
    }

    protected List<Chromosome> randomism() {
        logger.debug("Randomism");
        ArrayList<Chromosome> randoms = new ArrayList<Chromosome>();
        for (int i = 0; i < Properties.ELITE; ++i) {
            randoms.add((Chromosome)this.chromosomeFactory.getChromosome());
        }
        return randoms;
    }

    public Chromosome getBestIndividual() {
        if (this.population.isEmpty()) {
            return this.chromosomeFactory.getChromosome();
        }
        return (Chromosome)this.population.get(0);
    }

    public List<T> getBestIndividuals() {
        ArrayList<T> bestIndividuals = new ArrayList<T>();
        if (this.population.isEmpty()) {
            bestIndividuals.add(this.chromosomeFactory.getChromosome());
            return bestIndividuals;
        }
        if (Properties.ALGORITHM == Properties.Algorithm.NSGAII) {
            return this.population;
        }
        bestIndividuals.add(this.population.get(0));
        return bestIndividuals;
    }

    public void setChromosomeFactory(ChromosomeFactory<T> factory) {
        this.chromosomeFactory = factory;
    }

    public void setCrossOverFunction(CrossOverFunction crossover) {
        this.crossoverFunction = crossover;
    }

    public void addListener(SearchListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SearchListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifySearchStarted() {
        for (SearchListener listener : this.listeners) {
            listener.searchStarted(this);
        }
    }

    protected void notifySearchFinished() {
        for (SearchListener listener : this.listeners) {
            listener.searchFinished(this);
        }
    }

    protected void notifyIteration() {
        for (SearchListener listener : this.listeners) {
            listener.iteration(this);
        }
    }

    protected void notifyEvaluation(Chromosome chromosome) {
        for (SearchListener listener : this.listeners) {
            listener.fitnessEvaluation(chromosome);
        }
    }

    protected void notifyMutation(Chromosome chromosome) {
        for (SearchListener listener : this.listeners) {
            listener.modification(chromosome);
        }
    }

    protected void sortPopulation() {
        if (Properties.SHUFFLE_GOALS) {
            Randomness.shuffle(this.population);
        }
        if (this.fitnessFunctions.get(0).isMaximizationFunction()) {
            Collections.sort(this.population, Collections.reverseOrder());
        } else {
            Collections.sort(this.population);
        }
    }

    public List<T> getPopulation() {
        return this.population;
    }

    public boolean isNextPopulationFull(List<T> nextGeneration) {
        return this.populationLimit.isPopulationFull(nextGeneration);
    }

    public void setPopulationLimit(PopulationLimit limit) {
        this.populationLimit = limit;
    }

    public boolean isFinished() {
        for (StoppingCondition c : this.stoppingConditions) {
            if (!c.isFinished()) continue;
            return true;
        }
        return false;
    }

    public void addStoppingCondition(StoppingCondition condition) {
        Iterator<StoppingCondition> it = this.stoppingConditions.iterator();
        while (it.hasNext()) {
            if (!it.next().getClass().equals(condition.getClass())) continue;
            return;
        }
        logger.debug("Adding new stopping condition");
        this.stoppingConditions.add(condition);
        this.addListener(condition);
    }

    public void setStoppingCondition(StoppingCondition condition) {
        this.stoppingConditions.clear();
        logger.debug("Setting stopping condition");
        this.stoppingConditions.add(condition);
        this.addListener(condition);
    }

    public void removeStoppingCondition(StoppingCondition condition) {
        Iterator<StoppingCondition> it = this.stoppingConditions.iterator();
        while (it.hasNext()) {
            if (!it.next().getClass().equals(condition.getClass())) continue;
            it.remove();
            this.removeListener(condition);
        }
    }

    public void resetStoppingConditions() {
        for (StoppingCondition c : this.stoppingConditions) {
            c.reset();
        }
    }

    public void setStoppingConditionLimit(int value) {
        for (StoppingCondition c : this.stoppingConditions) {
            c.setLimit(value);
        }
    }

    protected boolean isBetterOrEqual(Chromosome chromosome1, Chromosome chromosome2) {
        if (this.getFitnessFunction().isMaximizationFunction()) {
            return chromosome1.compareTo(chromosome2) >= 0;
        }
        return chromosome1.compareTo(chromosome2) <= 0;
    }

    public void printBudget() {
        LoggingUtils.getEvoLogger().info("* GA-Budget:");
        for (StoppingCondition sc : this.stoppingConditions) {
            LoggingUtils.getEvoLogger().info("\t- " + sc.toString());
        }
    }

    public String getBudgetString() {
        String r = "";
        for (StoppingCondition sc : this.stoppingConditions) {
            r = r + sc.toString() + " ";
        }
        return r;
    }
}

