/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.ccfg;

import org.evosuite.graphs.ccfg.CCFGCodeNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;

public class CCFGFieldClassCallNode
extends CCFGCodeNode {
    private String className;
    private String methodName;
    private String methodParameters;

    public CCFGFieldClassCallNode(BytecodeInstruction code, String className, String methodName, String methodParameters) {
        super(code);
        this.className = className;
        this.methodName = methodName;
        this.methodParameters = methodParameters;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName + this.methodParameters;
    }

    public String getOnlyMethodName() {
        return this.methodName;
    }

    public String getOnlyParameters() {
        return this.methodParameters;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.methodParameters == null ? 0 : this.methodParameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CCFGFieldClassCallNode other = (CCFGFieldClassCallNode)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.methodParameters == null ? other.methodParameters != null : !this.methodParameters.equals(other.methodParameters));
    }
}

