/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.ccfg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.graphs.EvoSuiteGraph;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.ccfg.CCFGCodeEdge;
import org.evosuite.graphs.ccfg.CCFGCodeNode;
import org.evosuite.graphs.ccfg.CCFGEdge;
import org.evosuite.graphs.ccfg.CCFGEdgeAttributeProvider;
import org.evosuite.graphs.ccfg.CCFGFieldClassCallNode;
import org.evosuite.graphs.ccfg.CCFGFrameEdge;
import org.evosuite.graphs.ccfg.CCFGFrameNode;
import org.evosuite.graphs.ccfg.CCFGMethodCallEdge;
import org.evosuite.graphs.ccfg.CCFGMethodCallNode;
import org.evosuite.graphs.ccfg.CCFGMethodEntryNode;
import org.evosuite.graphs.ccfg.CCFGMethodExitNode;
import org.evosuite.graphs.ccfg.CCFGMethodReturnNode;
import org.evosuite.graphs.ccfg.CCFGNode;
import org.evosuite.graphs.ccfg.CCFGNodeAttributeProvider;
import org.evosuite.graphs.ccg.ClassCallGraph;
import org.evosuite.graphs.ccg.ClassCallNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlFlowEdge;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.utils.JdkPureMethodsList;
import org.objectweb.asm.Type;

public class ClassControlFlowGraph
extends EvoSuiteGraph<CCFGNode, CCFGEdge> {
    private final String className;
    private final ClassCallGraph ccg;
    private final ClassLoader classLoader;
    private Map<String, CCFGMethodEntryNode> methodEntries = new HashMap<String, CCFGMethodEntryNode>();
    private Map<String, CCFGMethodExitNode> methodExits = new HashMap<String, CCFGMethodExitNode>();
    public Set<CCFGMethodEntryNode> publicMethods = new HashSet<CCFGMethodEntryNode>();
    private Map<FrameNodeType, CCFGFrameNode> frameNodes = new HashMap<FrameNodeType, CCFGFrameNode>();
    private Set<String> pureMethods = new HashSet<String>();
    private Set<String> impureMethods = new HashSet<String>();
    private static Set<String> methodsInPurityAnalysis = new HashSet<String>();

    public ClassControlFlowGraph(ClassCallGraph ccg) {
        super(CCFGEdge.class);
        this.className = ccg.getClassName();
        this.ccg = ccg;
        this.classLoader = ccg.getClassLoader();
        this.nicenDotOutput();
        this.compute();
    }

    public boolean isPure(String methodName) {
        if (this.pureMethods.contains(methodName)) {
            return true;
        }
        if (this.impureMethods.contains(methodName)) {
            return false;
        }
        boolean isPure = this.analyzePurity(methodName);
        if (isPure) {
            this.pureMethods.add(methodName);
            return true;
        }
        this.impureMethods.add(methodName);
        return false;
    }

    private boolean analyzePurity(String methodName) {
        if (!this.methodEntries.containsKey(methodName)) {
            return true;
        }
        CCFGMethodEntryNode entry = this.getMethodEntryOf(methodName);
        HashSet<CCFGNode> handled = new HashSet<CCFGNode>();
        methodsInPurityAnalysis.add(this.className + "." + methodName);
        boolean r = this.analyzePurity(methodName, entry, handled);
        methodsInPurityAnalysis.remove(this.className + "." + methodName);
        return r;
    }

    private boolean analyzePurity(String analyzedMethod, CCFGNode currentNode, Set<CCFGNode> handled) {
        String toAnalyze;
        if (handled.contains(currentNode)) {
            return true;
        }
        handled.add(currentNode);
        CCFGNode nextNode = currentNode;
        if (currentNode instanceof CCFGFieldClassCallNode) {
            CCFGFieldClassCallNode fieldCall = (CCFGFieldClassCallNode)currentNode;
            toAnalyze = fieldCall.getClassName() + "." + fieldCall.getMethodName();
            if (GraphPool.getInstance(this.classLoader).canMakeCCFGForClass(fieldCall.getClassName())) {
                ClassControlFlowGraph ccfg;
                if (!methodsInPurityAnalysis.contains(toAnalyze) && !(ccfg = GraphPool.getInstance(this.classLoader).getCCFG(fieldCall.getClassName())).isPure(fieldCall.getMethodName())) {
                    return false;
                }
            } else if (toAnalyze.startsWith("java.")) {
                Type[] parameters = Type.getArgumentTypes(fieldCall.getOnlyParameters());
                String newParams = "";
                if (parameters.length != 0) {
                    for (Type i : parameters) {
                        newParams = newParams + "," + i.getClassName();
                    }
                    newParams = newParams.substring(1, newParams.length());
                }
                toAnalyze = fieldCall.getClassName() + "." + fieldCall.getOnlyMethodName() + "(" + newParams + ")";
                return JdkPureMethodsList.instance.checkPurity(toAnalyze);
            }
        } else if (currentNode instanceof CCFGCodeNode) {
            CCFGCodeNode codeNode = (CCFGCodeNode)currentNode;
            if (codeNode.getCodeInstruction().isFieldDefinition()) {
                return false;
            }
        } else {
            if (currentNode instanceof CCFGMethodExitNode) {
                CCFGMethodExitNode methodExit = (CCFGMethodExitNode)currentNode;
                if (methodExit.getMethod().equals(analyzedMethod)) {
                    return true;
                }
                throw new IllegalStateException("MethodExitNodes from methods other then the currently analyzed one should not be reached");
            }
            if (currentNode instanceof CCFGMethodCallNode) {
                CCFGMethodCallNode callNode = (CCFGMethodCallNode)currentNode;
                toAnalyze = this.className + "." + callNode.getCalledMethod();
                if (!methodsInPurityAnalysis.contains(toAnalyze) && !this.isPure(callNode.getCalledMethod())) {
                    return false;
                }
                nextNode = callNode.getReturnNode();
            } else if (!(currentNode instanceof CCFGMethodEntryNode)) {
                throw new IllegalStateException("purity analysis should not reach this kind of CCFGNode: " + currentNode.getClass().toString());
            }
        }
        Set<CCFGNode> children = this.getChildren(nextNode);
        for (CCFGNode child : children) {
            if (this.analyzePurity(analyzedMethod, child, handled)) continue;
            return false;
        }
        return true;
    }

    public boolean isPublicMethod(String method) {
        if (method == null) {
            return false;
        }
        CCFGMethodEntryNode entry = this.getMethodEntryOf(method);
        return this.isPublicMethod(entry);
    }

    public boolean isPublicMethod(CCFGMethodEntryNode node) {
        if (node == null) {
            return false;
        }
        return this.publicMethods.contains(node);
    }

    public CCFGMethodEntryNode getMethodEntryNodeForClassCallNode(ClassCallNode ccgNode) {
        CCFGMethodEntryNode r = this.methodEntries.get(ccgNode.getMethod());
        if (r == null) {
            throw new IllegalStateException("expect the CCFG to contain a CCFGMethodEntryNode for each node in the corresponding CCG " + ccgNode.getMethod());
        }
        return r;
    }

    private CCFGMethodEntryNode getMethodEntryOf(String method) {
        CCFGMethodEntryNode r = this.methodEntries.get(method);
        if (r == null) {
            throw new IllegalArgumentException("unknown method: " + method);
        }
        return r;
    }

    private RawControlFlowGraph getRCFG(ClassCallNode ccgNode) {
        return GraphPool.getInstance(this.classLoader).getRawCFG(this.className, ccgNode.getMethod());
    }

    public CCFGMethodExitNode getMethodExitOf(CCFGMethodEntryNode methodEntry) {
        if (methodEntry == null) {
            return null;
        }
        return this.methodExits.get(methodEntry.getMethod());
    }

    public CCFGMethodEntryNode getMethodEntryOf(CCFGMethodExitNode methodExit) {
        if (methodExit == null) {
            return null;
        }
        return this.methodEntries.get(methodExit.getMethod());
    }

    private void compute() {
        this.importCFGs();
        this.addFrame();
    }

    private void importCFGs() {
        HashMap<RawControlFlowGraph, Map<BytecodeInstruction, CCFGCodeNode>> tempMap = new HashMap<RawControlFlowGraph, Map<BytecodeInstruction, CCFGCodeNode>>();
        for (ClassCallNode ccgNode : this.ccg.vertexSet()) {
            RawControlFlowGraph cfg = this.getRCFG(ccgNode);
            tempMap.put(cfg, this.importCFG(cfg));
        }
        this.connectCFGs(tempMap);
    }

    private void connectCFGs(Map<RawControlFlowGraph, Map<BytecodeInstruction, CCFGCodeNode>> tempMap) {
        for (RawControlFlowGraph cfg : tempMap.keySet()) {
            List<BytecodeInstruction> calls = cfg.determineMethodCallsToOwnClass();
            for (BytecodeInstruction call : calls) {
                if (!call.isCallToStaticMethod() && !call.isMethodCallOnSameObject()) continue;
                this.connectCFG(cfg, call, tempMap);
            }
        }
    }

    private void connectCFG(RawControlFlowGraph cfg, BytecodeInstruction call, Map<RawControlFlowGraph, Map<BytecodeInstruction, CCFGCodeNode>> tempMap) {
        CCFGMethodReturnNode returnNode = new CCFGMethodReturnNode(call);
        CCFGMethodCallNode callNode = new CCFGMethodCallNode(call, returnNode);
        this.addVertex(callNode);
        this.addVertex(returnNode);
        CCFGNode calleeEntry = this.methodEntries.get(call.getCalledMethod());
        CCFGNode calleeExit = this.methodExits.get(call.getCalledMethod());
        CCFGMethodCallEdge callEdge = new CCFGMethodCallEdge(call, true);
        CCFGMethodCallEdge returnEdge = new CCFGMethodCallEdge(call, false);
        this.addEdge(callNode, calleeEntry, callEdge);
        this.addEdge(calleeExit, returnNode, returnEdge);
        CCFGNode origCallNode = tempMap.get(cfg).get(call);
        if (!this.redirectEdges(origCallNode, callNode, returnNode) || !this.graph.removeVertex(origCallNode)) {
            throw new IllegalStateException("internal error while connecting cfgs during CCFG construction");
        }
    }

    private Map<BytecodeInstruction, CCFGCodeNode> importCFG(RawControlFlowGraph cfg) {
        HashMap<BytecodeInstruction, CCFGCodeNode> temp = new HashMap<BytecodeInstruction, CCFGCodeNode>();
        this.importCFGNodes(cfg, temp);
        this.importCFGEdges(cfg, temp);
        this.encloseCFG(cfg, temp);
        return temp;
    }

    private void importCFGNodes(RawControlFlowGraph cfg, Map<BytecodeInstruction, CCFGCodeNode> temp) {
        for (BytecodeInstruction code : cfg.vertexSet()) {
            CCFGCodeNode node = code.isMethodCallOfField() ? new CCFGFieldClassCallNode(code, code.getCalledMethodsClass(), code.getCalledMethodName(), code.getMethodCallDescriptor()) : new CCFGCodeNode(code);
            this.addVertex(node);
            temp.put(code, node);
        }
    }

    private void importCFGEdges(RawControlFlowGraph cfg, Map<BytecodeInstruction, CCFGCodeNode> temp) {
        for (ControlFlowEdge e : cfg.edgeSet()) {
            if (e.isExceptionEdge()) continue;
            CCFGCodeNode src = temp.get(cfg.getEdgeSource(e));
            CCFGCodeNode target = temp.get(cfg.getEdgeTarget(e));
            this.addEdge(src, target, new CCFGCodeEdge(e));
        }
    }

    private void encloseCFG(RawControlFlowGraph cfg, Map<BytecodeInstruction, CCFGCodeNode> temp) {
        this.addCCFGMethodEntryNode(cfg, temp);
        this.addCCFGMethodExitNode(cfg, temp);
    }

    private CCFGMethodEntryNode addCCFGMethodEntryNode(RawControlFlowGraph cfg, Map<BytecodeInstruction, CCFGCodeNode> temp) {
        CCFGCodeNode entryInstruction = temp.get(cfg.determineEntryPoint());
        CCFGMethodEntryNode entry = new CCFGMethodEntryNode(cfg.getMethodName(), entryInstruction);
        this.addVertex(entry);
        this.addEdge(entry, entryInstruction);
        this.methodEntries.put(cfg.getMethodName(), entry);
        return entry;
    }

    private CCFGMethodExitNode addCCFGMethodExitNode(RawControlFlowGraph cfg, Map<BytecodeInstruction, CCFGCodeNode> temp) {
        CCFGMethodExitNode exit = new CCFGMethodExitNode(cfg.getMethodName());
        this.addVertex(exit);
        for (BytecodeInstruction exitPoint : cfg.determineExitPoints()) {
            this.addEdge(temp.get(exitPoint), exit);
        }
        this.methodExits.put(cfg.getMethodName(), exit);
        return exit;
    }

    private void addFrame() {
        this.addFrameNodes();
        this.addFrameEdges();
        this.connectPublicMethodsToFrame();
    }

    private void addFrameNodes() {
        for (FrameNodeType type : FrameNodeType.values()) {
            CCFGFrameNode node = new CCFGFrameNode(type);
            this.addVertex(node);
            this.frameNodes.put(type, node);
        }
    }

    private void addFrameEdges() {
        this.addEdge(this.getFrameNode(FrameNodeType.ENTRY), this.getFrameNode(FrameNodeType.LOOP), new CCFGFrameEdge());
        this.addEdge(this.getFrameNode(FrameNodeType.LOOP), this.getFrameNode(FrameNodeType.CALL), new CCFGFrameEdge());
        this.addEdge(this.getFrameNode(FrameNodeType.LOOP), this.getFrameNode(FrameNodeType.EXIT), new CCFGFrameEdge());
        this.addEdge(this.getFrameNode(FrameNodeType.RETURN), this.getFrameNode(FrameNodeType.LOOP), new CCFGFrameEdge());
    }

    public CCFGFrameNode getFrameNode(FrameNodeType type) {
        return this.frameNodes.get((Object)type);
    }

    private void connectPublicMethodsToFrame() {
        for (ClassCallNode ccgNode : this.ccg.vertexSet()) {
            RawControlFlowGraph cfg = this.getRCFG(ccgNode);
            if (!cfg.isPublicMethod()) continue;
            this.addEdge(this.getFrameNode(FrameNodeType.CALL), this.methodEntries.get(ccgNode.getMethod()), new CCFGFrameEdge());
            this.addEdge(this.methodExits.get(ccgNode.getMethod()), this.getFrameNode(FrameNodeType.RETURN), new CCFGFrameEdge());
            this.publicMethods.add(this.methodEntries.get(ccgNode.getMethod()));
        }
    }

    private void nicenDotOutput() {
        this.registerVertexAttributeProvider(new CCFGNodeAttributeProvider());
        this.registerEdgeAttributeProvider(new CCFGEdgeAttributeProvider());
    }

    @Override
    public String getName() {
        return "CCFG_" + this.className;
    }

    @Override
    protected String dotSubFolder() {
        return this.toFileString(this.className) + "/";
    }

    public ClassCallGraph getCcg() {
        return this.ccg;
    }

    public static enum FrameNodeType {
        ENTRY,
        EXIT,
        LOOP,
        CALL,
        RETURN;

    }
}

