/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.ccg;

import java.util.List;
import java.util.Map;
import org.evosuite.graphs.EvoSuiteGraph;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.ccg.ClassCallEdge;
import org.evosuite.graphs.ccg.ClassCallNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.RawControlFlowGraph;

public class ClassCallGraph
extends EvoSuiteGraph<ClassCallNode, ClassCallEdge> {
    private final String className;
    private final ClassLoader classLoader;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassCallGraph(ClassLoader classLoader, String className) {
        super(ClassCallEdge.class);
        this.className = className;
        this.classLoader = classLoader;
        this.compute();
    }

    private void compute() {
        Map<String, RawControlFlowGraph> cfgs = GraphPool.getInstance(this.classLoader).getRawCFGs(this.className);
        if (cfgs == null) {
            throw new IllegalStateException("did not find CFGs for a class I was supposed to compute the CCG of");
        }
        for (String method : cfgs.keySet()) {
            this.addVertex(new ClassCallNode(method));
        }
        for (ClassCallNode methodNode : this.graph.vertexSet()) {
            RawControlFlowGraph rcfg = cfgs.get(methodNode.getMethod());
            List<BytecodeInstruction> calls = rcfg.determineMethodCallsToOwnClass();
            for (BytecodeInstruction call : calls) {
                ClassCallNode calledMethod = this.getNodeByMethodName(call.getCalledMethod());
                if (calledMethod == null) continue;
                ClassCallEdge e = new ClassCallEdge(call);
                this.addEdge(methodNode, calledMethod, e);
            }
        }
    }

    public ClassCallNode getNodeByMethodName(String methodName) {
        ClassCallNode r = null;
        for (ClassCallNode node : this.graph.vertexSet()) {
            if (!node.getMethod().equals(methodName)) continue;
            if (r == null) {
                r = node;
                continue;
            }
            throw new IllegalStateException("Expect each ClassCallNode to have a unique method name");
        }
        return r;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String getName() {
        return "CCG_" + this.className;
    }

    @Override
    protected String dotSubFolder() {
        return this.toFileString(this.className) + "/";
    }
}

