/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFGClassAdapter
extends ClassVisitor {
    private static Logger logger = LoggerFactory.getLogger(CFGClassAdapter.class);
    private final String className;
    private final ClassLoader classLoader;
    private boolean isEnum = false;

    public CFGClassAdapter(ClassLoader classLoader, ClassVisitor visitor, String className) {
        super(327680, visitor);
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (superName.equals("java/lang/Enum")) {
            this.isEnum = true;
        }
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, methodAccess, name, descriptor, signature, exceptions);
        if ((methodAccess & 0x1000) != 0 || (methodAccess & 0x40) != 0) {
            return mv;
        }
        if (!Properties.USE_DEPRECATED && (methodAccess & 0x20000) == 131072) {
            logger.info("Skipping deprecated method " + name);
            return mv;
        }
        if (this.isEnum && (name.equals("valueOf") || name.equals("values"))) {
            logger.info("Skipping enum valueOf");
            return mv;
        }
        logger.info("Analyzing CFG of " + this.className);
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(this.className);
        mv = new CFGMethodAdapter(this.classLoader, classNameWithDots, methodAccess, name, descriptor, signature, exceptions, mv);
        return mv;
    }
}

