/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.instrumentation.error.ArrayInstrumentation;
import org.evosuite.instrumentation.error.ArrayListInstrumentation;
import org.evosuite.instrumentation.error.CastErrorInstrumentation;
import org.evosuite.instrumentation.error.DequeInstrumentation;
import org.evosuite.instrumentation.error.DivisionByZeroInstrumentation;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.LinkedHashSetInstrumentation;
import org.evosuite.instrumentation.error.LinkedListInstrumentation;
import org.evosuite.instrumentation.error.NullPointerExceptionInstrumentation;
import org.evosuite.instrumentation.error.OverflowInstrumentation;
import org.evosuite.instrumentation.error.QueueInstrumentation;
import org.evosuite.instrumentation.error.StackInstrumentation;
import org.evosuite.instrumentation.error.VectorInstrumentation;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.runtime.instrumentation.AnnotatedMethodNode;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorConditionMethodAdapter
extends GeneratorAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ErrorConditionMethodAdapter.class);
    private final String className;
    private final String methodName;
    private final MethodVisitor next;
    protected List<ErrorBranchInstrumenter> instrumentation;
    protected boolean inInstrumentation = false;

    public ErrorConditionMethodAdapter(MethodVisitor mv, String className, String methodName, int access, String desc) {
        super(327680, new AnnotatedMethodNode(access, methodName, desc, null, null), access, methodName, desc);
        this.className = className;
        this.methodName = methodName;
        this.next = mv;
        this.initErrorBranchInstrumenters();
    }

    private void initErrorBranchInstrumenters() {
        this.instrumentation = new ArrayList<ErrorBranchInstrumenter>();
        this.instrumentation.add(new ArrayInstrumentation(this));
        this.instrumentation.add(new ArrayListInstrumentation(this));
        this.instrumentation.add(new CastErrorInstrumentation(this));
        this.instrumentation.add(new DequeInstrumentation(this));
        this.instrumentation.add(new DivisionByZeroInstrumentation(this));
        this.instrumentation.add(new LinkedHashSetInstrumentation(this));
        this.instrumentation.add(new LinkedListInstrumentation(this));
        this.instrumentation.add(new NullPointerExceptionInstrumentation(this));
        this.instrumentation.add(new OverflowInstrumentation(this));
        this.instrumentation.add(new QueueInstrumentation(this));
        this.instrumentation.add(new StackInstrumentation(this));
        this.instrumentation.add(new VectorInstrumentation(this));
    }

    @Override
    public void visitLabel(Label label) {
        if (label instanceof AnnotatedLabel) {
            AnnotatedLabel aLabel = (AnnotatedLabel)label;
            this.inInstrumentation = aLabel.isStartTag();
        }
        super.visitLabel(label);
    }

    public void tagBranch() {
        AnnotatedLabel dummyTag = new AnnotatedLabel(false, true);
        super.visitLabel(dummyTag);
    }

    public void tagBranchExit() {
        AnnotatedLabel dummyTag = new AnnotatedLabel(false, false);
        super.visitLabel(dummyTag);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.inInstrumentation) {
            this.inInstrumentation = true;
            for (ErrorBranchInstrumenter instrumenter : this.instrumentation) {
                instrumenter.visitMethodInsn(opcode, owner, name, desc, itf);
            }
            this.inInstrumentation = false;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (!this.inInstrumentation) {
            this.inInstrumentation = true;
            for (ErrorBranchInstrumenter instrumenter : this.instrumentation) {
                instrumenter.visitFieldInsn(opcode, owner, name, desc);
            }
            this.inInstrumentation = false;
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (!this.inInstrumentation) {
            this.inInstrumentation = true;
            for (ErrorBranchInstrumenter instrumenter : this.instrumentation) {
                instrumenter.visitIntInsn(opcode, operand);
            }
            this.inInstrumentation = false;
        }
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (!this.inInstrumentation) {
            this.inInstrumentation = true;
            for (ErrorBranchInstrumenter instrumenter : this.instrumentation) {
                instrumenter.visitTypeInsn(opcode, type);
            }
            this.inInstrumentation = false;
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitInsn(int opcode) {
        if (!this.inInstrumentation) {
            this.inInstrumentation = true;
            for (ErrorBranchInstrumenter instrumenter : this.instrumentation) {
                instrumenter.visitInsn(opcode);
            }
            this.inInstrumentation = false;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitEnd() {
        MethodNode mn = (MethodNode)this.mv;
        mn.accept(this.next);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack + 4, maxLocals);
    }
}

