/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.ArrayAllocationLimitMethodAdapter;
import org.evosuite.instrumentation.ExplicitExceptionHandler;
import org.evosuite.instrumentation.LineNumberMethodAdapter;
import org.evosuite.instrumentation.MethodEntryAdapter;
import org.evosuite.instrumentation.ReturnValueAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.utils.ArrayUtil;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionPathClassAdapter
extends ClassVisitor {
    private final String className;
    private static Logger logger = LoggerFactory.getLogger(ExecutionPathClassAdapter.class);

    private static boolean isMutation() {
        return ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.WEAKMUTATION);
    }

    public ExecutionPathClassAdapter(ClassVisitor visitor, String className) {
        super(327680, visitor);
        this.className = ResourceList.getClassNameFromResourcePath(className);
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        if ((methodAccess & 0x1000) > 0 || (methodAccess & 0x40) > 0) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            return mv;
        }
        if (!DependencyAnalysis.shouldInstrument(this.className, name + descriptor)) {
            return mv;
        }
        if (ExecutionPathClassAdapter.isMutation()) {
            mv = new ReturnValueAdapter(mv, this.className, name, descriptor);
        }
        mv = new MethodEntryAdapter(mv, methodAccess, this.className, name, descriptor);
        mv = new LineNumberMethodAdapter(mv, this.className, name, descriptor);
        mv = new ArrayAllocationLimitMethodAdapter(mv, this.className, name, methodAccess, descriptor);
        mv = new ExplicitExceptionHandler(mv, this.className, name, descriptor);
        return mv;
    }
}

