/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.evosuite.instrumentation.ExitClassInitMethodAdapter;
import org.evosuite.runtime.reset.ResetManager;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExitClassInitAdapter
extends ClassVisitor {
    private static Logger logger = LoggerFactory.getLogger(ExitClassInitAdapter.class);
    private final String className;
    private boolean isInterface = false;
    private boolean clinitFound = false;
    private boolean hasStaticFields = false;
    private static final String EXIT_CLASS_INIT = "exitClassInit";

    public ExitClassInitAdapter(ClassVisitor visitor, String className) {
        super(327680, visitor);
        this.className = className;
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String methodName, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, methodName, descriptor, signature, exceptions);
        if (methodName.equals("<clinit>")) {
            this.clinitFound = true;
            ExitClassInitMethodAdapter staticResetMethodAdapter = new ExitClassInitMethodAdapter(this.className, methodName, mv);
            return staticResetMethodAdapter;
        }
        return mv;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.isInterface = (access & 0x200) == 512;
    }

    @Override
    public void visitEnd() {
        if (!this.clinitFound && !this.isInterface && this.hasStaticFields) {
            this.createEmptyClassInit();
        }
        super.visitEnd();
    }

    private static boolean isStatic(int access) {
        return (access & 8) == 8;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ExitClassInitAdapter.isStatic(access)) {
            this.hasStaticFields = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private void createEmptyClassInit() {
        logger.info("Creating <clinit> in class " + this.className);
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        String executionTracerClassName = ResetManager.class.getName().replace(".", "/");
        String executionTracerDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class));
        String classNameWithDots = this.className.replace("/", ".");
        mv.visitLdcInsn(classNameWithDots);
        mv.visitMethodInsn(184, executionTracerClassName, EXIT_CLASS_INIT, executionTracerDescriptor, false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

