/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.runtime.reset.ResetManager;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ExitClassInitMethodAdapter
extends MethodVisitor {
    private static final String EXIT_CLASS_INIT = "exitClassInit";
    private final String className;
    private final String methodName;
    private Label startingTryLabel;
    private Label endingTryLabel;
    private final List<TryCatchBlock> tryCatchBlocks = new LinkedList<TryCatchBlock>();

    public ExitClassInitMethodAdapter(String className, String methodName, MethodVisitor mv) {
        super(327680, mv);
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 177 && this.methodName.equals("<clinit>")) {
            String executionTracerClassName = ResetManager.class.getName().replace(".", "/");
            String executionTracerDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class));
            String classNameWithDots = this.className.replace("/", ".");
            super.visitLdcInsn(classNameWithDots);
            super.visitMethodInsn(184, executionTracerClassName, EXIT_CLASS_INIT, executionTracerDescriptor, false);
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitCode() {
        super.visitCode();
        if (this.methodName.equals("<clinit>")) {
            this.startingTryLabel = new Label();
            this.endingTryLabel = new Label();
            super.visitLabel(this.startingTryLabel);
        }
    }

    @Override
    public void visitEnd() {
        if (this.methodName.equals("<clinit>")) {
            super.visitLabel(this.endingTryLabel);
            String executionTracerClassName = ResetManager.class.getName().replace(".", "/");
            String executionTracerDescriptor = Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class));
            String classNameWithDots = this.className.replace("/", ".");
            super.visitLdcInsn(classNameWithDots);
            super.visitMethodInsn(184, executionTracerClassName, EXIT_CLASS_INIT, executionTracerDescriptor, false);
            super.visitInsn(191);
            for (TryCatchBlock tryCatchBlock : this.tryCatchBlocks) {
                super.visitTryCatchBlock(tryCatchBlock.start, tryCatchBlock.end, tryCatchBlock.handler, tryCatchBlock.type);
            }
            super.visitTryCatchBlock(this.startingTryLabel, this.endingTryLabel, this.endingTryLabel, null);
        }
        super.visitEnd();
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.methodName.equals("<clinit>")) {
            TryCatchBlock block = new TryCatchBlock(start, end, handler, type);
            this.tryCatchBlocks.add(block);
        }
        super.visitTryCatchBlock(start, end, handler, type);
    }

    private static class TryCatchBlock {
        Label start;
        Label end;
        Label handler;
        String type;

        public TryCatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

