/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentingClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingClassLoader.class);
    private final BytecodeInstrumentation instrumentation;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public InstrumentingClassLoader() {
        this(new BytecodeInstrumentation());
        this.setClassAssertionStatus(Properties.TARGET_CLASS, true);
    }

    public InstrumentingClassLoader(BytecodeInstrumentation instrumentation) {
        super(InstrumentingClassLoader.class.getClassLoader());
        this.classLoader = InstrumentingClassLoader.class.getClassLoader();
        this.instrumentation = instrumentation;
    }

    public List<String> getViewOfInstrumentedClasses() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.classes.keySet());
        return list;
    }

    public Class<?> loadClassFromFile(String fullyQualifiedTargetClass, String fileName) throws ClassNotFoundException {
        String className = fullyQualifiedTargetClass.replace('.', '/');
        InputStream is = null;
        try {
            is = new FileInputStream(new File(fileName));
            byte[] byteBuffer = this.instrumentation.transformBytes(this, className, new ClassReader(is));
            this.createPackageDefinition(fullyQualifiedTargetClass);
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Keeping class: " + fullyQualifiedTargetClass);
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            logger.info("Error while loading class: " + t);
            throw new ClassNotFoundException(t.getMessage(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if ("<evosuite>".equals(name)) {
            throw new ClassNotFoundException();
        }
        if (!BytecodeInstrumentation.checkIfCanInstrument(name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        logger.info("Seeing class for first time: " + name);
        Class<?> instrumentedClass = null;
        instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        logger.info("Instrumenting class '" + fullyQualifiedTargetClass + "'.");
        InputStream is = null;
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            is = ResourceList.getClassAsStream(fullyQualifiedTargetClass);
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class" + "' should be in target project, but could not be found!");
            }
            byte[] byteBuffer = this.instrumentation.transformBytes(this, className, new ClassReader(is));
            this.createPackageDefinition(fullyQualifiedTargetClass);
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Keeping class: " + fullyQualifiedTargetClass);
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            logger.info("Error while loading class: " + t);
            throw new ClassNotFoundException(t.getMessage(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    public boolean hasInstrumentedClass(String className) {
        return this.classes.containsKey(className);
    }

    private void createPackageDefinition(String className) {
        String pkgname;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = className.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
            logger.info("Defined package (3): " + this.getPackage(pkgname) + ", " + this.getPackage(pkgname).hashCode());
        }
    }

    public BytecodeInstrumentation getInstrumentation() {
        return this.instrumentation;
    }
}

