/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodEntryAdapter
extends AdviceAdapter {
    private static Logger logger = LoggerFactory.getLogger(MethodEntryAdapter.class);
    String className;
    String methodName;
    String fullMethodName;
    int access;

    public MethodEntryAdapter(MethodVisitor mv, int access, String className, String methodName, String desc) {
        super(327680, mv, access, methodName, desc);
        this.className = className;
        this.methodName = methodName;
        this.fullMethodName = methodName + desc;
        this.access = access;
    }

    @Override
    public void onMethodEnter() {
        if (this.methodName.equals("<clinit>")) {
            return;
        }
        this.mv.visitLdcInsn(this.className);
        this.mv.visitLdcInsn(this.fullMethodName);
        if ((this.access & 8) > 0) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitMethodInsn(184, "org/evosuite/testcase/ExecutionTracer", "enteredMethod", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", false);
        super.onMethodEnter();
    }

    @Override
    public void onMethodExit(int opcode) {
        if (opcode != 191) {
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.fullMethodName);
            this.mv.visitMethodInsn(184, "org/evosuite/testcase/ExecutionTracer", "leftMethod", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        }
        super.onMethodExit(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        int maxNum = 3;
        super.visitMaxs(Math.max(maxNum, maxStack), maxLocals);
    }
}

