/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.instrumentation.ErrorConditionMethodAdapter;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;

public class LinkedHashSetInstrumentation
extends ErrorBranchInstrumenter {
    private final String SETNAME = LinkedHashSet.class.getCanonicalName().replace('.', '/');
    private final List<String> emptyListMethods = Arrays.asList("first", "last");

    public LinkedHashSetInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (owner.equals(this.SETNAME) && this.emptyListMethods.contains(name)) {
            Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
            this.tagBranchStart();
            this.mv.visitMethodInsn(182, this.SETNAME, "isEmpty", "()Z", false);
            this.insertBranchWithoutTag(158, "java/util/NoSuchElementException");
            this.tagBranchEnd();
            this.restoreMethodParameters(tempVariables, desc);
        }
    }
}

